// Click Detection Script - Add this to admin to detect what's happening
console.log('🔍 Click Detector Loaded');

// Detect ALL clicks anywhere on the page
document.addEventListener('click', function(e) {
    console.log('🖱️ CLICK DETECTED:', {
        target: e.target,
        tagName: e.target.tagName,
        className: e.target.className,
        id: e.target.id,
        dataPage: e.target.getAttribute('data-page'),
        coordinates: `${e.clientX}, ${e.clientY}`,
        timestamp: new Date().toLocaleTimeString()
    });
    
    // Check if it's a navigation link
    if (e.target.hasAttribute('data-page')) {
        console.log('🎯 NAVIGATION LINK CLICKED:', e.target.getAttribute('data-page'));
        console.log('🔧 window.app exists:', !!window.app);
        console.log('🔧 navigateTo exists:', !!(window.app && window.app.navigateTo));
    }
}, true);

// Detect mousedown events too
document.addEventListener('mousedown', function(e) {
    if (e.target.hasAttribute('data-page')) {
        console.log('👆 MOUSEDOWN on navigation link:', e.target.getAttribute('data-page'));
    }
}, true);

// Check for elements that might be intercepting clicks
function checkElementAtPoint(x, y) {
    const element = document.elementFromPoint(x, y);
    console.log(`🎯 Element at ${x}, ${y}:`, {
        tagName: element.tagName,
        className: element.className,
        id: element.id,
        isNavLink: element.hasAttribute('data-page'),
        dataPage: element.getAttribute('data-page')
    });
}

// Auto-check navigation areas
setTimeout(() => {
    console.log('🔍 Auto-checking navigation areas...');
    
    const navLinks = document.querySelectorAll('[data-page]');
    navLinks.forEach((link, index) => {
        const rect = link.getBoundingClientRect();
        const centerX = rect.left + rect.width / 2;
        const centerY = rect.top + rect.height / 2;
        
        console.log(`📍 Nav Link ${index + 1} (${link.getAttribute('data-page')}):`);
        console.log(`   Position: ${rect.left}, ${rect.top}`);
        console.log(`   Size: ${rect.width} x ${rect.height}`);
        console.log(`   Center: ${centerX}, ${centerY}`);
        
        checkElementAtPoint(centerX, centerY);
    });
}, 2000);

// Make this function available globally for manual testing
window.checkClick = checkElementAtPoint;
window.testNavigation = function(page) {
    console.log(`🧪 Manual navigation test: ${page}`);
    if (window.app && window.app.navigateTo) {
        console.log('✅ Calling navigateTo...');
        window.app.navigateTo(page);
    } else {
        console.log('❌ App not ready');
    }
};

console.log('🔍 Click Detector Ready! Use window.checkClick(x, y) or window.testNavigation("page") for manual testing');