// Arabic Language Pack
const translations_ar = {
    // Common - المشتركة
    'common.loading': 'جاري التحميل...',
    'common.save': 'حفظ',
    'common.cancel': 'إلغاء',
    'common.delete': 'حذف',
    'common.edit': 'تعديل',
    'common.add': 'إضافة',
    'common.search': 'بحث',
    'common.filter': 'تصفية',
    'common.actions': 'الإجراءات',
    'common.status': 'الحالة',
    'common.enabled': 'مفعل',
    'common.disabled': 'معطل',
    'common.yes': 'نعم',
    'common.no': 'لا',
    'common.success': 'نجح',
    'common.error': 'خطأ',
    'common.warning': 'تحذير',
    'common.info': 'معلومات',
    
    // Navigation - التنقل
    'nav.dashboard': 'لوحة التحكم',
    'nav.masters': 'البيانات الأساسية',
    'nav.academic_years': 'السنوات الدراسية',
    'nav.terms': 'الفصول الدراسية',
    'nav.grades': 'المراحل الدراسية',
    'nav.classes': 'الفصول',
    'nav.subjects': 'المواد الدراسية',
    'nav.grade_subject_rules': 'قواعد المراحل والمواد',
    'nav.students': 'الطلاب',
    'nav.enrollments': 'التسجيلات',
    'nav.student_cards': 'بطاقات الطلاب',
    'nav.academics': 'الأكاديميات',
    'nav.exams': 'الامتحانات',
    'nav.results': 'النتائج',
    'nav.finance': 'الماليات',
    'nav.payments': 'المدفوعات',
    'nav.system': 'النظام',
    'nav.users': 'إدارة المستخدمين',
    'nav.settings': 'الإعدادات',
    'nav.logout': 'تسجيل الخروج',
    
    // Login - تسجيل الدخول
    'login.title': 'تسجيل دخول الإدارة',
    'login.username': 'اسم المستخدم',
    'login.password': 'كلمة المرور',
    'login.login_btn': 'تسجيل الدخول',
    'login.error': 'فشل تسجيل الدخول. يرجى التحقق من بيانات الدخول.',
    
    // System - النظام
    'system.title': 'نظام المدرسة',
    'system.welcome': 'مرحباً بعودتك',
    
    // Dashboard - لوحة التحكم
    'dashboard.title': 'لوحة التحكم',
    'dashboard.welcome': 'مرحباً بك في نظام إدارة المدرسة',
    'dashboard.overview': 'نظرة عامة على النظام',
    'dashboard.total_students': 'إجمالي الطلاب',
    'dashboard.active_enrollments': 'التسجيلات النشطة',
    'dashboard.total_exams': 'إجمالي الامتحانات',
    'dashboard.payment_balance': 'رصيد المدفوعات',
    'dashboard.recent_activities': 'الأنشطة الأخيرة',
    'dashboard.loading': 'جاري التحميل...',
    'dashboard.no_activity': 'لا توجد أنشطة حديثة',
    'dashboard.loading_students': 'جاري تحميل الطلاب...',
    'dashboard.loading_enrollments': 'جاري تحميل التسجيلات...',
    'dashboard.loading_results': 'جاري التحميل...',
    'dashboard.payment_trends': 'اتجاهات المدفوعات (آخر 6 أشهر)',
    'dashboard.academic_performance': 'الأداء الأكاديمي',
    'dashboard.quick_actions': 'الإجراءات السريعة',
    'dashboard.add_new_student': 'إضافة طالب جديد',
    'dashboard.create_exam': 'إنشاء امتحان',
    'dashboard.new_student_prefix': 'طالب جديد:',
    
    // Date filters - مرشحات التاريخ
    'filter.today': 'اليوم',
    'filter.this_week': 'هذا الأسبوع',
    'filter.this_month': 'هذا الشهر',
    'filter.this_year': 'هذا العام',
    
    // Common buttons - الأزرار الشائعة
    'btn.cancel': 'إلغاء',
    'btn.update': 'تحديث',
    'btn.create': 'إنشاء',
    'btn.save': 'حفظ',
    'btn.edit': 'تعديل',
    'btn.delete': 'حذف',
    'btn.close': 'إغلاق',
    'btn.submit': 'إرسال',
    'btn.download_csv': 'تحميل قالب CSV',
    'btn.print_report': 'طباعة التقرير',
    'btn.record_payment': 'تسجيل دفعة',
    'btn.update_payment': 'تحديث الدفعة',
    'btn.save_result': 'حفظ النتيجة',
    'btn.update_result': 'تحديث النتيجة',
    'btn.import_results': 'استيراد النتائج',
    
    // Table headers - عناوين الجدول
    'table.actions': 'الإجراءات',
    'table.status': 'الحالة',
    'table.created': 'تاريخ الإنشاء',
    'table.last_login': 'آخر دخول',
    'table.notes': 'ملاحظات',
    'table.created_by': 'أنشئ بواسطة',
    
    // Modal titles - عناوين النوافذ
    'modal.edit_student': 'تعديل الطالب',
    'modal.update_student': 'تحديث الطالب',
    'modal.create_exam_group': 'إنشاء مجموعة امتحانات',
    'modal.edit_academic_year': 'تعديل السنة الدراسية',
    'modal.update_academic_year': 'تحديث السنة الدراسية',
    'modal.add_academic_year': 'إضافة سنة دراسية',
    'modal.save_academic_year': 'حفظ السنة الدراسية',
    
    // Academic Years - السنوات الدراسية
    'academic_years.title': 'السنوات الدراسية',
    'academic_years.subtitle': 'إدارة فترات السنوات الدراسية والإعدادات',
    'academic_years.add_year': 'إضافة سنة دراسية',
    'academic_years.search_by_name': 'البحث بالاسم',
    'academic_years.search_placeholder': 'مثال: 2024-2025',
    'academic_years.all_status': 'كل الحالات',
    'academic_years.open': 'مفتوح',
    'academic_years.closed': 'مغلق',
    'academic_years.filter': 'تصفية',
    'academic_years.clear': 'مسح',
    'academic_years.year_name': 'اسم السنة الدراسية',
    'academic_years.start_date': 'تاريخ البداية',
    'academic_years.end_date': 'تاريخ النهاية',
    'academic_years.select_status': 'اختر الحالة',
    'academic_years.name_placeholder': 'مثال: 2024-2025',
    
    // Table headers for Academic Years - عناوين جدول السنوات الدراسية
    'table.year_name': 'الاسم',
    'table.start_date': 'تاريخ البداية',
    'table.end_date': 'تاريخ النهاية',
    
    // Terms - الفصول الدراسية
    'terms.title': 'الفصول الدراسية',
    'terms.subtitle': 'إدارة الفصول والفترات الدراسية',
    'terms.add_term': 'إضافة فصل دراسي',
    'terms.search_by_name': 'البحث بالاسم',
    'terms.search_placeholder': 'مثال: الفصل الأول',
    'terms.visibility': 'الرؤية',
    'terms.all': 'الكل',
    'terms.visible_to_students': 'مرئي للطلاب',
    'terms.hidden_from_students': 'مخفي عن الطلاب',
    'terms.filter': 'تصفية',
    'terms.clear': 'مسح',
    'terms.term_name': 'اسم الفصل الدراسي',
    'terms.sort_order': 'ترتيب الفرز',
    'terms.visible_to_students_label': 'مرئي للطلاب',
    'terms.publish_date': 'تاريخ ووقت النشر',
    'terms.select_visibility': 'اختر الرؤية',
    'terms.yes_visible': 'نعم - مرئي للطلاب',
    'terms.no_hidden': 'لا - مخفي عن الطلاب',
    'terms.name_placeholder': 'مثال: الفصل الأول',
    'terms.publish_help': 'اختياري: متى تجعل نتائج هذا الفصل مرئية للطلاب',
    'terms.save_term': 'حفظ الفصل الدراسي',
    'terms.update_term': 'تحديث الفصل الدراسي',
    'terms.edit_term': 'تعديل الفصل الدراسي',
    'terms.no_terms_found': 'لم يتم العثور على فصول دراسية',
    'terms.error_loading': 'خطأ في تحميل الفصول الدراسية',
    
    // Table headers for Terms - عناوين جدول الفصول الدراسية
    'table.term_name': 'الاسم',
    'table.sort_order': 'الترتيب',
    'table.visibility': 'مرئي للطلاب',
    'table.publish_date': 'تاريخ النشر',
    
    // Grades - المراحل الدراسية
    'grades.title': 'المراحل الدراسية',
    'grades.subtitle': 'إدارة مستويات المراحل الدراسية',
    'grades.add_grade': 'إضافة مرحلة دراسية',
    'grades.search': 'بحث',
    'grades.search_placeholder': 'البحث بالرمز أو العنوان',
    'grades.status': 'الحالة',
    'grades.all': 'الكل',
    'grades.enabled': 'مفعل',
    'grades.disabled': 'معطل',
    'grades.filter': 'تصفية',
    'grades.clear': 'مسح',
    'grades.grade_code': 'رمز المرحلة',
    'grades.grade_title': 'عنوان المرحلة',
    'grades.sort_order': 'ترتيب الفرز',
    'grades.status_label': 'الحالة',
    'grades.select_status': 'اختر الحالة',
    'grades.code_placeholder': 'مثال: ص٢1، رس1',
    'grades.title_placeholder': 'مثال: الصف الأول، الروضة الأولى',
    'grades.disabled_help': 'المراحل المعطلة غير متاحة للتسجيلات الجديدة',
    'grades.save_grade': 'حفظ المرحلة',
    'grades.update_grade': 'تحديث المرحلة',
    'grades.edit_grade': 'تعديل المرحلة',
    'grades.no_grades_found': 'لم يتم العثور على مراحل دراسية',
    'grades.error_loading': 'خطأ في تحميل المراحل الدراسية',
    
    // Table headers for Grades - عناوين جدول المراحل الدراسية
    'table.grade_code': 'الرمز',
    'table.grade_title': 'العنوان',
    'table.grade_order': 'الترتيب',
    'table.grade_status': 'الحالة',
    
    // Classes - الفصول
    'classes.title': 'الفصول',
    'classes.subtitle': 'إدارة أقسام الفصول داخل المراحل',
    'classes.add_class': 'إضافة فصل',
    'classes.class_name': 'اسم الفصل',
    'classes.search_placeholder': 'ابحث في اسم الفصل...',
    'classes.status': 'الحالة',
    'classes.all_statuses': 'جميع الحالات',
    'classes.active': 'نشط',
    'classes.disabled': 'معطل',
    'classes.search': 'بحث',
    'classes.clear': 'مسح',
    'classes.export': 'تصدير',
    'classes.export_csv': 'تصدير CSV',
    'classes.export_excel': 'تصدير Excel',
    'classes.print': 'طباعة',
    'classes.loading': 'جاري تحميل الفصول...',
    'classes.class_name_label': 'اسم الفصل',
    'classes.status_label': 'الحالة',
    'classes.name_placeholder': 'مثال: أ، ب، أحمر، ألفا، أخضر',
    'classes.name_help': 'معرف الفصل الذي يمكن إعادة استخدامه عبر جميع المراحل والسنوات',
    'classes.note': 'ملاحظة: الفصول أصبحت مستقلة وقابلة للإعادة. عند إنشاء تسجيلات الطلاب، ستختار السنة الدراسية والمرحلة والفصل بشكل منفصل.',
    'classes.save_class': 'حفظ الفصل',
    'classes.update_class': 'تحديث الفصل',
    'classes.edit_class': 'تعديل الفصل',
    'classes.no_classes_found': 'لم يتم العثور على فصول',
    'classes.add_classes_help': 'أضف فصول يمكن إعادة استخدامها عبر جميع المراحل والسنوات',
    'classes.failed_to_load': 'فشل في تحميل الفصول',
    'classes.error_loading': 'خطأ في تحميل الفصول',
    
    // Table headers for Classes - عناوين جدول الفصول
    'table.class_name': 'اسم الفصل',
    'table.class_status': 'الحالة',
    'table.class_created': 'تم الإنشاء',
    
    // Subjects - المواد الدراسية
    'subjects.title': 'المواد الدراسية',
    'subjects.subtitle': 'إدارة المواد الدراسية',
    'subjects.add_subject': 'إضافة مادة دراسية',
    'subjects.subject_name': 'اسم المادة',
    'subjects.search_placeholder': 'ابحث في اسم المادة...',
    'subjects.status': 'الحالة',
    'subjects.all_statuses': 'جميع الحالات',
    'subjects.active': 'نشط',
    'subjects.disabled': 'معطل',
    'subjects.search': 'بحث',
    'subjects.clear': 'مسح',
    'subjects.export': 'تصدير',
    'subjects.export_csv': 'تصدير CSV',
    'subjects.export_excel': 'تصدير Excel',
    'subjects.print': 'طباعة',
    'subjects.loading': 'جاري تحميل المواد...',
    'subjects.quick_add_title': 'إضافة سريعة للمواد الشائعة',
    'subjects.mathematics': 'الرياضيات',
    'subjects.english_language': 'اللغة الإنجليزية',
    'subjects.science': 'العلوم',
    'subjects.social_studies': 'الدراسات الاجتماعية',
    'subjects.art_craft': 'الفنون والحرف',
    'subjects.physical_education': 'التربية البدنية',
    'subjects.computer_science': 'علوم الحاسوب',
    'subjects.music': 'الموسيقى',
    'subjects.subject_name_label': 'اسم المادة',
    'subjects.status_label': 'الحالة',
    'subjects.name_placeholder': 'مثال: الرياضيات، اللغة الإنجليزية',
    'subjects.name_help': 'أدخل اسم المادة الكامل (2-100 حرف)',
    'subjects.save_subject': 'حفظ المادة',
    'subjects.update_subject': 'تحديث المادة',
    'subjects.edit_subject': 'تعديل المادة',
    'subjects.no_subjects_found': 'لم يتم العثور على مواد دراسية',
    'subjects.failed_to_load': 'فشل في تحميل المواد',
    'subjects.error_loading': 'خطأ في تحميل المواد',
    
    // Table headers for Subjects - عناوين جدول المواد
    'table.subject_name': 'اسم المادة',
    'table.subject_status': 'الحالة',
    'table.subject_created': 'تم الإنشاء',
    'dashboard.total_teachers': 'إجمالي المعلمين',
    'dashboard.total_classes': 'إجمالي الفصول',
    'dashboard.academic_year': 'السنة الدراسية الحالية',
    
    // Students - الطلاب
    'students.title': 'إدارة الطلاب',
    'students.subtitle': 'إدارة معلومات الطلاب ورموز الدخول',
    'students.add_student': 'إضافة طالب',
    'students.import_students': 'استيراد طلاب',
    'students.import_with_enrollment': 'استيراد مع التسجيل',
    'students.delete_selected': 'حذف المحدد',
    'students.selected_count': 'محدد',
    'students.search_name': 'البحث بالاسم',
    'students.search_by_name': 'البحث بالاسم...',
    'students.search_by_id': 'البحث بالرقم...',
    'students.full_name': 'الاسم الكامل',
    'students.national_id': 'الرقم القومي',
    'students.login_code': 'رمز الدخول',
    'students.gender': 'الجنس',
    'students.birthdate': 'تاريخ الميلاد',
    'students.grade': 'المرحلة الدراسية',
    'students.class': 'الفصل',
    'students.year': 'السنة الدراسية',
    'students.academic_year': 'السنة الدراسية',
    'students.status': 'الحالة',
    'students.male': 'ذكر',
    'students.female': 'أنثى',
    'students.all': 'الكل',
    'students.all_years': 'كل السنوات',
    'students.select_gender': 'اختر الجنس',
    'students.optional': 'اختياري',
    'students.save_student': 'حفظ الطالب',
    'students.edit_student': 'تعديل الطالب',
    'students.enrollment_status': 'حالة التسجيل',
    'students.per_page': 'في الصفحة',
    'students.filter': 'تصفية',
    'students.clear': 'مسح',
    'students.id': 'الرقم',
    'students.login_code_header': 'رمز الدخول',
    'students.full_name_header': 'الاسم الكامل',
    'students.gender_header': 'الجنس',
    'students.year_header': 'السنة',
    'students.grade_header': 'المرحلة',
    'students.class_header': 'الفصل',
    'students.status_header': 'الحالة',
    'students.actions': 'الإجراءات',
    'students.auto_generated': 'توليد تلقائي',
    'students.login_code_help': 'رمز فريد من 8 أرقام لتسجيل دخول الطالب',
    'students.enrollment_info': 'معلومات التسجيل',
    'students.enroll_immediately': 'تسجيل الطالب فوراً',
    'students.enroll_help': 'اختر هذا لتعيين الطالب لفصل فوراً',
    'students.active': 'نشط',
    'students.disabled': 'معطل',
    'students.inactive': 'غير نشط',
    'students.graduated': 'متخرج',
    
    // Enrollments - إدارة التسجيلات
    'enrollments.title': 'إدارة التسجيلات',
    'enrollments.subtitle': 'إدارة تسجيلات الطلاب وتخصيص الفصول',
    'enrollments.transfer_selected': 'نقل المحدد',
    'enrollments.bulk_enroll': 'تسجيل جماعي',
    'enrollments.add_enrollment': 'إضافة تسجيل',
    'enrollments.student_name': 'اسم الطالب',
    'enrollments.search_placeholder': 'ابحث باسم الطالب...',
    'enrollments.academic_year': 'السنة الدراسية',
    'enrollments.all_years': 'جميع السنوات',
    'enrollments.grade': 'المرحلة',
    'enrollments.all_grades': 'جميع المراحل',
    'enrollments.class': 'الفصل',
    'enrollments.all_classes': 'جميع الفصول',
    'enrollments.status': 'الحالة',
    'enrollments.all': 'الكل',
    'enrollments.active': 'نشط',
    'enrollments.inactive': 'غير نشط',
    'enrollments.graduated': 'متخرج',
    'enrollments.transferred': 'منقول',
    'enrollments.per_page': 'في الصفحة',
    'enrollments.filter': 'تصفية',
    'enrollments.clear': 'مسح',
    'enrollments.list_title': 'قائمة التسجيلات',
    'enrollments.loading': 'جاري تحميل التسجيلات...',
    
    // Table headers for Enrollments - عناوين جدول التسجيلات
    'table.enrollment_id': 'الرقم',
    'table.enrollment_student': 'الطالب',
    'table.enrollment_year': 'السنة',
    'table.enrollment_grade': 'المرحلة',
    'table.enrollment_class': 'الفصل',
    'table.enrollment_status': 'الحالة',
    'table.enrollment_date': 'تاريخ التسجيل',
    'table.enrollment_actions': 'الإجراءات',
    
    // Exams - الامتحانات
    'exams.title': 'الامتحانات',
    'exams.subtitle': 'إدارة الامتحانات والتقييمات',
    'exams.add_exam': 'إضافة امتحان',
    'exams.add_exam_group': 'إضافة مجموعة امتحانات',
    'exams.search': 'بحث',
    'exams.search_placeholder': 'ابحث بالعنوان',
    'exams.year': 'السنة',
    'exams.all_years': 'جميع السنوات',
    'exams.term': 'الفصل الدراسي',
    'exams.all_terms': 'جميع الفصول',
    'exams.grade': 'المرحلة',
    'exams.all_grades': 'جميع المراحل',
    'exams.filter': 'تصفية',
    'exams.clear': 'مسح',
    'exams.select_all': 'تحديد الكل',
    'exams.delete_selected': 'حذف المحدد',
    'exams.export': 'تصدير',
    'exams.loading': 'جاري تحميل الامتحانات...',
    'exams.no_exams_found': 'لم يتم العثور على امتحانات',
    'exams.failed_to_load': 'فشل في تحميل الامتحانات',
    
    // Table headers for Exams - عناوين جدول الامتحانات
    'table.exam_title': 'العنوان',
    'table.exam_year': 'السنة',
    'table.exam_term': 'الفصل',
    'table.exam_grade': 'المرحلة',
    'table.exam_subject': 'المادة',
    'table.exam_date': 'تاريخ الامتحان',
    'table.exam_score_range': 'نطاق الدرجات',
    'table.exam_status': 'الحالة',
    'table.exam_actions': 'الإجراءات',
    
    // Results - إدارة النتائج
    'results.title': 'إدارة النتائج',
    'results.subtitle': 'إدارة نتائج الامتحانات وأداء الطلاب',
    'results.add_result': 'إضافة نتيجة',
    'results.bulk_by_exam': 'إدخال جماعي لامتحان',
    'results.student_results': 'نتائج الطالب',
    'results.import': 'استيراد',
    'results.export': 'تصدير',
    'results.delete_selected': 'حذف المحدد',
    'results.filters_search': 'المرشحات والبحث',
    'results.all_years': 'جميع السنوات',
    'results.all_terms': 'جميع الفصول',
    'results.all_grades': 'جميع المراحل',
    'results.all_subjects': 'جميع المواد',
    'results.all_exams': 'جميع الامتحانات',
    'results.search_students': 'البحث في الطلاب...',
    'results.apply_filters': 'تطبيق المرشحات',
    'results.clear_filters': 'مسح',
    'results.results_list': 'قائمة النتائج',
    'results.select_all': 'تحديد الكل',
    'results.loading': 'جاري تحميل النتائج...',
    'results.no_results_found': 'لم يتم العثور على نتائج',
    'results.error_loading': 'خطأ في تحميل النتائج',
    'results.failed_to_load': 'فشل في تحميل النتائج',
    'results.count': 'نتيجة موجودة',
    'results.showing': 'عرض',
    'results.to': 'إلى',
    'results.of': 'من',
    'results.results': 'النتائج',
    
    // Table headers for Results - عناوين جدول النتائج
    'table.result_student': 'الطالب',
    'table.result_exam': 'الامتحان',
    'table.result_score': 'الدرجة',
    'table.result_percentage': 'النسبة المئوية',
    'table.result_pass_fail': 'حالة النجاح/الرسوب',
    'table.result_year_term': 'السنة/الفصل',
    'table.result_subject': 'المادة',
    'table.result_date_added': 'تاريخ الإضافة',
    'table.result_actions': 'الإجراءات',
    
    // Payments - إدارة المدفوعات
    'payments.title': 'المدفوعات',
    'payments.subtitle': 'إدارة مدفوعات الطلاب وتتبع الرسوم',
    'payments.search_options': 'خيارات البحث',
    'payments.search_help': 'اختر كيف تريد البحث عن المدفوعات:',
    'payments.student_search_pay': 'البحث عن الطلاب والدفع',
    'payments.student_search_desc': 'العثور على طلاب محددين لعرض الجدول الزمني للمدفوعات وتسجيل مدفوعات جديدة',
    'payments.search_placeholder': 'البحث بالاسم أو رقم الطالب أو الرقم القومي...',
    'payments.search_students': 'البحث عن الطلاب',
    'payments.payment_history_search': 'البحث في تاريخ المدفوعات',
    'payments.payment_history_desc': 'البحث في جميع المدفوعات عبر الطلاب باستخدام المرشحات (السنة، المرحلة، الفصل، التاريخ، المبلغ)',
    'payments.search_all_history': 'البحث في جميع تاريخ المدفوعات',
    'payments.show_advanced_filters': 'إظهار المرشحات المتقدمة',
    'payments.hide_advanced_filters': 'إخفاء المرشحات المتقدمة',
    'payments.academic_year': 'السنة الدراسية',
    'payments.all_years': 'جميع السنوات',
    'payments.grade': 'المرحلة',
    'payments.all_grades': 'جميع المراحل',
    'payments.class': 'الفصل',
    'payments.all_classes': 'جميع الفصول',
    'payments.payment_method': 'طريقة الدفع',
    'payments.all_methods': 'جميع الطرق',
    'payments.cash': 'نقدي',
    'payments.card': 'بطاقة',
    'payments.bank_transfer': 'تحويل بنكي',
    'payments.digital_wallet': 'محفظة رقمية',
    'payments.date_from': 'التاريخ من',
    'payments.date_to': 'التاريخ إلى',
    'payments.min_amount': 'الحد الأدنى للمبلغ',
    'payments.max_amount': 'الحد الأقصى للمبلغ',
    'payments.quick_date_filters': 'مرشحات التاريخ السريعة',
    'payments.show_only': 'إظهار فقط',
    'payments.last_payments': 'آخر المدفوعات',
    'payments.recent_30_days': 'الحديثة (30 يوماً)',
    'payments.old_90_days': 'القديمة (90+ يوماً)',
    'payments.apply_filters': 'تطبيق المرشحات',
    'payments.clear_all': 'مسح الكل',
    'payments.search_results': 'نتائج البحث',
    'payments.payment_history_results': 'نتائج البحث في تاريخ المدفوعات',
    'payments.payments_found': 'مدفوعات موجودة',
    'payments.record_payment': 'تسجيل دفعة',
    'payments.failed_to_load': 'فشل في تحميل المدفوعات',
    'payments.failed_search': 'فشل في البحث عن المدفوعات',
    'payments.failed_record': 'فشل في تسجيل الدفعة',
    'payments.failed_update': 'فشل في تحديث الدفعة',
    'payments.failed_delete': 'فشل في حذف الدفعة',
    
    // Table headers for Payments - عناوين جدول المدفوعات
    'table.payment_student': 'الطالب',
    'table.payment_amount': 'المبلغ',
    'table.payment_method': 'الطريقة',
    'table.payment_date': 'التاريخ',
    'table.payment_year': 'السنة',
    'table.payment_grade': 'المرحلة',
    'table.payment_class': 'الفصل',
    'table.payment_notes': 'الملاحظات',
    'table.payment_actions': 'الإجراءات',
    
    // User Management - إدارة المستخدمين
    'users.title': 'إدارة المستخدمين',
    'users.subtitle': 'إدارة مستخدمي الإدارة وصلاحياتهم',
    'users.add_user': 'إضافة مستخدم',
    'users.search': 'بحث',
    'users.search_placeholder': 'اسم المستخدم أو الاسم الكامل...',
    'users.role': 'الدور',
    'users.all_roles': 'جميع الأدوار',
    'users.status': 'الحالة',
    'users.all_statuses': 'جميع الحالات',
    'users.enabled': 'مفعل',
    'users.disabled': 'معطل',
    'users.sort_by': 'ترتيب حسب',
    'users.order': 'الترتيب',
    'users.descending': 'تنازلي',
    'users.ascending': 'تصاعدي',
    'users.loading': 'جاري تحميل المستخدمين...',
    'users.error_loading': 'خطأ في تحميل المستخدمين',
    'users.error_loading_data': 'خطأ في تحميل بيانات المستخدمين',
    'users.username': 'اسم المستخدم',
    'users.full_name': 'الاسم الكامل',
    'users.last_login': 'آخر دخول',
    'users.created': 'تم الإنشاء',
    'users.never': 'أبداً',
    'users.admin': 'مدير',
    'users.registrar': 'مسجل',
    'users.teacher': 'معلم',
    'users.accountant': 'محاسب',
    'users.edit_user': 'تعديل المستخدم',
    'users.add_new_user': 'إضافة مستخدم جديد',
    'users.username_label': 'اسم المستخدم *',
    'users.username_placeholder': 'أدخل اسم المستخدم',
    'users.full_name_label': 'الاسم الكامل *',
    'users.full_name_placeholder': 'أدخل الاسم الكامل',
    'users.password_label': 'كلمة المرور',
    'users.password_placeholder': 'أدخل كلمة المرور (اتركها فارغة للاحتفاظ بالحالية)',
    'users.role_label': 'الدور *',
    'users.select_role': 'اختر الدور',
    'users.enabled_label': 'مفعل',
    'users.save_user': 'حفظ المستخدم',
    'users.user_created': 'تم إنشاء المستخدم بنجاح',
    'users.user_updated': 'تم تحديث المستخدم بنجاح',
    'users.confirm_delete': 'هل أنت متأكد من حذف هذا المستخدم؟ لا يمكن التراجع عن هذا الإجراء.',
    'users.error_saving': 'خطأ في حفظ المستخدم',
    'users.error_loading_user': 'خطأ في تحميل بيانات المستخدم',
    'users.error_updating_status': 'خطأ في تحديث حالة المستخدم',
    'users.error_deleting': 'خطأ في حذف المستخدم',
    
    // Table headers for Users - عناوين جدول المستخدمين
    'table.user_id': 'الرقم',
    'table.user_username': 'اسم المستخدم',
    'table.user_full_name': 'الاسم الكامل',
    'table.user_role': 'الدور',
    'table.user_status': 'الحالة',
    'table.user_last_login': 'آخر دخول',
    'table.user_created': 'تم الإنشاء',
    'table.user_actions': 'الإجراءات',
    
    // Settings - الإعدادات
    'settings.title': 'إعدادات النظام',
    'settings.subtitle': 'تكوين تفضيلات النظام والسياسات',
    'settings.save_all': 'حفظ جميع الإعدادات',
    'settings.school_settings': 'إعدادات المدرسة',
    'settings.school_name': 'اسم المدرسة',
    'settings.school_name_placeholder': 'أدخل اسم المدرسة',
    'settings.school_name_help': 'سيظهر هذا على بطاقات الطلاب والبوابة',
    'settings.portal_url': 'رابط بوابة الطلاب',
    'settings.portal_url_placeholder': 'http://localhost/student1/student/',
    'settings.portal_url_help': 'الرابط لرموز QR على بطاقات الطلاب',
    'settings.academic_visibility': 'رؤية الأكاديميات',
    'settings.current_academic_year': 'السنة الدراسية الحالية',
    'settings.select_year': 'اختر السنة',
    'settings.first_term_visible': 'نتائج الفصل الأول مرئية',
    'settings.first_term_publish_date': 'تاريخ نشر الفصل الأول',
    'settings.second_term_visible': 'نتائج الفصل الثاني مرئية',
    'settings.second_term_publish_date': 'تاريخ نشر الفصل الثاني',
    'settings.display_options': 'خيارات العرض',
    'settings.display_mode': 'وضع العرض',
    'settings.color_only': 'اللون فقط',
    'settings.color_score': 'اللون + الدرجة',
    'settings.color_score_percent': 'اللون + الدرجة + النسبة المئوية',
    'settings.percentage_rounding': 'تقريب النسبة المئوية (الأماكن العشرية)',
    'settings.rounding_0': '0 (85%)',
    'settings.rounding_1': '1 (84.5%)',
    'settings.rounding_2': '2 (84.56%)',
    'settings.pass_rules': 'قواعد النجاح',
    'settings.per_subject_threshold': 'وضع حد المادة',
    'settings.use_grade_subject_min': 'استخدام الحد الأدنى لمادة المرحلة',
    'settings.fixed_percentage': 'نسبة مئوية ثابتة',
    'settings.subject_pass_min_percent': 'الحد الأدنى لنجاح المادة بالنسبة المئوية',
    'settings.overall_pass_rule': 'قاعدة النجاح الإجمالية',
    'settings.none': 'لا شيء',
    'settings.avg_at_least': 'المتوسط على الأقل',
    'settings.overall_pass_min_percent': 'الحد الأدنى للنجاح الإجمالي بالنسبة المئوية',
    'settings.pass_condition': 'شرط النجاح',
    'settings.all_subjects_only': 'جميع المواد فقط',
    'settings.overall_only': 'الإجمالي فقط',
    'settings.all_subjects_or_overall': 'جميع المواد أو الإجمالي',
    'settings.all_subjects_and_overall': 'جميع المواد والإجمالي',
    'settings.security_policy': 'سياسة الأمان',
    'settings.mask_national_id': 'إخفاء الرقم القومي في واجهة الإدارة',
    'settings.unique_national_id': 'تسجيل دخول الطالب يتطلب رقم قومي فريد',
    'settings.session_timeout': 'انتهاء مهلة الجلسة (بالدقائق)',
    'settings.grade_costs': 'رسوم المراحل',
    'settings.add_grade_cost': 'إضافة رسوم مرحلة',
    'settings.select_grade': 'اختر المرحلة',
    'settings.amount_placeholder': 'المبلغ',
    'settings.no_grade_costs': 'لم يتم تكوين رسوم المراحل. انقر على "إضافة رسوم مرحلة" للبدء.',
    'settings.percentage_bands': 'نطاقات النسب المئوية',
    'settings.add_percentage_band': 'إضافة نطاق نسبة مئوية',
    'settings.grade_visibility': 'رؤية نتائج المراحل',
    'settings.add_grade_visibility': 'إضافة قاعدة رؤية المرحلة',
    'settings.grade_visibility_help': 'التحكم في أي مراحل يمكنها رؤية النتائج في بوابة الطلاب. يحتاج الطلاب أيضًا لدفع رسوم المراحل لعرض النتائج.',
    'settings.failed_to_load': 'فشل في تحميل الإعدادات',
    'settings.failed_to_save': 'فشل في حفظ الإعدادات',
    
    // Import - الاستيراد
    'import.title': 'استيراد الطلاب',
    'import.with_enrollment': 'استيراد الطلاب مع التسجيل',
    'import.instructions': 'التعليمات',
    'import.required': 'مطلوب',
    'import.optional': 'اختياري',
    'import.download_template': 'تحميل قالب CSV',
    'import.csv_format': 'مثال على تنسيق CSV',
    'import.select_file': 'اختيار ملف CSV',
    'import.upload': 'رفع',
    'import.processing': 'جاري المعالجة...',
    'import.results': 'نتائج الاستيراد',
    'import.total_rows': 'إجمالي الصفوف',
    'import.successful': 'نجح',
    'import.failed': 'فشل',
    
    // Buttons and Actions - الأزرار والإجراءات
    'btn.save_all': 'حفظ جميع الإعدادات',
    'btn.download_csv': 'تحميل CSV',
    'btn.print_cards': 'طباعة البطاقات',
    'btn.view_timeline': 'عرض الجدول الزمني',
    'btn.record_payment': 'تسجيل دفعة',
    'btn.delete_selected': 'حذف المحدد',
    
    // Modals - النوافذ المنبثقة
    'modal.confirm_delete': 'هل أنت متأكد من حذف هذا العنصر؟',
    'modal.confirm_logout': 'هل أنت متأكد من تسجيل الخروج؟',
    'modal.close': 'إغلاق',
    
    // Messages - الرسائل
    'msg.saved_successfully': 'تم الحفظ بنجاح',
    'msg.deleted_successfully': 'تم الحذف بنجاح',
    'msg.error_occurred': 'حدث خطأ',
    'msg.no_data': 'لا توجد بيانات متاحة',
    'msg.loading_data': 'جاري تحميل البيانات...',
    
    // Form Labels - تسميات النموذج
    'form.select_year': 'اختر السنة',
    'form.select_grade': 'اختر المرحلة',
    'form.select_class': 'اختر الفصل',
    'form.select_subject': 'اختر المادة',
    'form.select_term': 'اختر الفصل الدراسي',
    'form.amount': 'المبلغ',
    'form.date': 'التاريخ',
    'form.notes': 'ملاحظات',
    
    // Table Headers - عناوين الجدول
    'table.id': 'الرقم',
    'table.name': 'الاسم',
    'table.code': 'الرمز',
    'table.title': 'العنوان',
    'table.created_at': 'تاريخ الإنشاء',
    'table.updated_at': 'تاريخ التحديث',
    
    // Language - اللغة
    'lang.english': 'English',
    'lang.arabic': 'العربية',
    'lang.switch_to': 'تبديل إلى'
};