// English Language Pack
const translations_en = {
    // Common
    'common.loading': 'Loading...',
    'common.save': 'Save',
    'common.cancel': 'Cancel',
    'common.delete': 'Delete',
    'common.edit': 'Edit',
    'common.add': 'Add',
    'common.search': 'Search',
    'common.filter': 'Filter',
    'common.actions': 'Actions',
    'common.status': 'Status',
    'common.enabled': 'Enabled',
    'common.disabled': 'Disabled',
    'common.yes': 'Yes',
    'common.no': 'No',
    'common.success': 'Success',
    'common.error': 'Error',
    'common.warning': 'Warning',
    'common.info': 'Information',
    
    // Navigation
    'nav.dashboard': 'Dashboard',
    'nav.masters': 'Masters',
    'nav.academic_years': 'Academic Years',
    'nav.terms': 'Terms',
    'nav.grades': 'Grades',
    'nav.classes': 'Classes',
    'nav.subjects': 'Subjects',
    'nav.grade_subject_rules': 'Grade-Subject Rules',
    'nav.students': 'Students',
    'nav.enrollments': 'Enrollments',
    'nav.student_cards': 'Student ID Cards',
    'nav.academics': 'Academics',
    'nav.exams': 'Exams',
    'nav.results': 'Results',
    'nav.finance': 'Finance',
    'nav.payments': 'Payments',
    'nav.system': 'System',
    'nav.users': 'User Management',
    'nav.settings': 'Settings',
    'nav.logout': 'Logout',
    
    // Login
    'login.title': 'Admin Login',
    'login.username': 'Username',
    'login.password': 'Password',
    'login.login_btn': 'Login',
    'login.error': 'Login failed. Please check your credentials.',
    
    // System
    'system.title': 'School System',
    'system.welcome': 'Welcome back',
    
    // Dashboard
    'dashboard.title': 'Dashboard',
    'dashboard.total_students': 'Total Students',
    'dashboard.active_enrollments': 'Active Enrollments',
    'dashboard.total_exams': 'Total Exams',
    'dashboard.payment_balance': 'Payment Balance',
    'dashboard.recent_activities': 'Recent Activities',
    'dashboard.loading': 'Loading...',
    'dashboard.no_activity': 'No recent activity',
    'dashboard.loading_students': 'Loading students...',
    'dashboard.loading_enrollments': 'Loading enrollments...',
    'dashboard.loading_results': 'Loading...',
    'dashboard.payment_trends': 'Payment Trends (Last 6 Months)',
    'dashboard.academic_performance': 'Academic Performance',
    'dashboard.quick_actions': 'Quick Actions',
    'dashboard.add_new_student': 'Add New Student',
    'dashboard.create_exam': 'Create Exam',
    'dashboard.new_student_prefix': 'New student:',
    
    // Date filters
    'filter.today': 'Today',
    'filter.this_week': 'This Week', 
    'filter.this_month': 'This Month',
    'filter.this_year': 'This Year',
    
    // Common buttons
    'btn.cancel': 'Cancel',
    'btn.update': 'Update',
    'btn.create': 'Create',
    'btn.save': 'Save',
    'btn.edit': 'Edit',
    'btn.delete': 'Delete',
    'btn.close': 'Close',
    'btn.submit': 'Submit',
    'btn.download_csv': 'Download CSV Template',
    'btn.print_report': 'Print Report',
    'btn.record_payment': 'Record Payment',
    'btn.update_payment': 'Update Payment',
    'btn.save_result': 'Save Result',
    'btn.update_result': 'Update Result',
    'btn.import_results': 'Import Results',
    
    // Table headers
    'table.actions': 'Actions',
    'table.status': 'Status',
    'table.created': 'Created',
    'table.last_login': 'Last Login',
    'table.notes': 'Notes',
    'table.created_by': 'Created By',
    
    // Modal titles
    'modal.edit_student': 'Edit Student',
    'modal.update_student': 'Update Student',
    'modal.create_exam_group': 'Create Exam Group',
    'modal.edit_academic_year': 'Edit Academic Year',
    'modal.update_academic_year': 'Update Academic Year',
    'modal.add_academic_year': 'Add Academic Year',
    'modal.save_academic_year': 'Save Academic Year',
    
    // Academic Years
    'academic_years.title': 'Academic Years',
    'academic_years.subtitle': 'Manage academic year periods and settings',
    'academic_years.add_year': 'Add Academic Year',
    'academic_years.search_by_name': 'Search by name',
    'academic_years.search_placeholder': 'e.g., 2024-2025',
    'academic_years.all_status': 'All Status',
    'academic_years.open': 'Open',
    'academic_years.closed': 'Closed',
    'academic_years.filter': 'Filter',
    'academic_years.clear': 'Clear',
    'academic_years.year_name': 'Academic Year Name',
    'academic_years.start_date': 'Start Date',
    'academic_years.end_date': 'End Date',
    'academic_years.select_status': 'Select status',
    'academic_years.name_placeholder': 'e.g., 2024-2025',
    
    // Table headers for Academic Years
    'table.year_name': 'Name',
    'table.start_date': 'Start Date',
    'table.end_date': 'End Date',
    
    // Terms
    'terms.title': 'Terms',
    'terms.subtitle': 'Manage academic terms and periods',
    'terms.add_term': 'Add Term',
    'terms.search_by_name': 'Search by name',
    'terms.search_placeholder': 'e.g., First Term',
    'terms.visibility': 'Visibility',
    'terms.all': 'All',
    'terms.visible_to_students': 'Visible to Students',
    'terms.hidden_from_students': 'Hidden from Students',
    'terms.filter': 'Filter',
    'terms.clear': 'Clear',
    'terms.term_name': 'Term Name',
    'terms.sort_order': 'Sort Order',
    'terms.visible_to_students_label': 'Visible to Students',
    'terms.publish_date': 'Publish Date & Time',
    'terms.select_visibility': 'Select visibility',
    'terms.yes_visible': 'Yes - Visible to Students',
    'terms.no_hidden': 'No - Hidden from Students',
    'terms.name_placeholder': 'e.g., First Term',
    'terms.publish_help': 'Optional: When to make this term\'s results visible to students',
    'terms.save_term': 'Save Term',
    'terms.update_term': 'Update Term',
    'terms.edit_term': 'Edit Term',
    'terms.no_terms_found': 'No terms found',
    'terms.error_loading': 'Error loading terms',
    
    // Table headers for Terms
    'table.term_name': 'Name',
    'table.sort_order': 'Order',
    'table.visibility': 'Visible to Students',
    'table.publish_date': 'Publish Date',
    
    // Grades
    'grades.title': 'Grades',
    'grades.subtitle': 'Manage academic grade levels',
    'grades.add_grade': 'Add Grade',
    'grades.search': 'Search',
    'grades.search_placeholder': 'Search by code or title',
    'grades.status': 'Status',
    'grades.all': 'All',
    'grades.enabled': 'Enabled',
    'grades.disabled': 'Disabled',
    'grades.filter': 'Filter',
    'grades.clear': 'Clear',
    'grades.grade_code': 'Grade Code',
    'grades.grade_title': 'Grade Title',
    'grades.sort_order': 'Sort Order',
    'grades.status_label': 'Status',
    'grades.select_status': 'Select status',
    'grades.code_placeholder': 'e.g., G1, KG1',
    'grades.title_placeholder': 'e.g., Grade 1, Kindergarten 1',
    'grades.disabled_help': 'Disabled grades are not available for new enrollments',
    'grades.save_grade': 'Save Grade',
    'grades.update_grade': 'Update Grade',
    'grades.edit_grade': 'Edit Grade',
    'grades.no_grades_found': 'No grades found',
    'grades.error_loading': 'Error loading grades',
    
    // Table headers for Grades
    'table.grade_code': 'Code',
    'table.grade_title': 'Title',
    'table.grade_order': 'Order',
    'table.grade_status': 'Status',
    
    // Classes
    'classes.title': 'Classes',
    'classes.subtitle': 'Manage class sections within grades',
    'classes.add_class': 'Add Class',
    'classes.class_name': 'Class Name',
    'classes.search_placeholder': 'Search class name...',
    'classes.status': 'Status',
    'classes.all_statuses': 'All Statuses',
    'classes.active': 'Active',
    'classes.disabled': 'Disabled',
    'classes.search': 'Search',
    'classes.clear': 'Clear',
    'classes.export': 'Export',
    'classes.export_csv': 'Export CSV',
    'classes.export_excel': 'Export Excel',
    'classes.print': 'Print',
    'classes.loading': 'Loading classes...',
    'classes.class_name_label': 'Class Name',
    'classes.status_label': 'Status',
    'classes.name_placeholder': 'e.g., A, B, Red, Alpha, Green',
    'classes.name_help': 'Class identifier that can be reused across all grades and years',
    'classes.note': 'Note: Classes are now independent and reusable. When creating student enrollments, you\'ll select the academic year, grade, and class separately.',
    'classes.save_class': 'Save Class',
    'classes.update_class': 'Update Class',
    'classes.edit_class': 'Edit Class',
    'classes.no_classes_found': 'No classes found',
    'classes.add_classes_help': 'Add classes that can be reused across all grades and years',
    'classes.failed_to_load': 'Failed to load classes',
    'classes.error_loading': 'Error loading classes',
    
    // Table headers for Classes
    'table.class_name': 'Class Name',
    'table.class_status': 'Status',
    'table.class_created': 'Created',
    
    // Subjects
    'subjects.title': 'Subjects',
    'subjects.subtitle': 'Manage academic subjects',
    'subjects.add_subject': 'Add Subject',
    'subjects.subject_name': 'Subject Name',
    'subjects.search_placeholder': 'Search subject name...',
    'subjects.status': 'Status',
    'subjects.all_statuses': 'All Statuses',
    'subjects.active': 'Active',
    'subjects.disabled': 'Disabled',
    'subjects.search': 'Search',
    'subjects.clear': 'Clear',
    'subjects.export': 'Export',
    'subjects.export_csv': 'Export CSV',
    'subjects.export_excel': 'Export Excel',
    'subjects.print': 'Print',
    'subjects.loading': 'Loading subjects...',
    'subjects.quick_add_title': 'Quick Add Common Subjects',
    'subjects.mathematics': 'Mathematics',
    'subjects.english_language': 'English Language',
    'subjects.science': 'Science',
    'subjects.social_studies': 'Social Studies',
    'subjects.art_craft': 'Art & Craft',
    'subjects.physical_education': 'Physical Education',
    'subjects.computer_science': 'Computer Science',
    'subjects.music': 'Music',
    'subjects.subject_name_label': 'Subject Name',
    'subjects.status_label': 'Status',
    'subjects.name_placeholder': 'e.g., Mathematics, English Language',
    'subjects.name_help': 'Enter the full subject name (2-100 characters)',
    'subjects.save_subject': 'Save Subject',
    'subjects.update_subject': 'Update Subject',
    'subjects.edit_subject': 'Edit Subject',
    'subjects.no_subjects_found': 'No subjects found',
    'subjects.failed_to_load': 'Failed to load subjects',
    'subjects.error_loading': 'Error loading subjects',
    
    // Table headers for Subjects
    'table.subject_name': 'Subject Name',
    'table.subject_status': 'Status',
    'table.subject_created': 'Created',
    
    // Dashboard
    'dashboard.title': 'Dashboard',
    'dashboard.welcome': 'Welcome to School Management System',
    'dashboard.overview': 'System Overview',
    'dashboard.total_students': 'Total Students',
    'dashboard.total_teachers': 'Total Teachers',
    'dashboard.total_classes': 'Total Classes',
    'dashboard.academic_year': 'Current Academic Year',
    
    // Students
    'students.title': 'Students Management',
    'students.subtitle': 'Manage student information and login codes',
    'students.add_student': 'Add Student',
    'students.import_students': 'Import Students',
    'students.import_with_enrollment': 'Import with Enrollment',
    'students.delete_selected': 'Delete Selected',
    'students.selected_count': 'Selected',
    'students.search_name': 'Search Name',
    'students.search_by_name': 'Search by name...',
    'students.search_by_id': 'Search by ID...',
    'students.full_name': 'Full Name',
    'students.national_id': 'National ID',
    'students.login_code': 'Login Code',
    'students.gender': 'Gender',
    'students.birthdate': 'Birth Date',
    'students.grade': 'Grade',
    'students.class': 'Class',
    'students.year': 'Academic Year',
    'students.academic_year': 'Academic Year',
    'students.status': 'Status',
    'students.male': 'Male',
    'students.female': 'Female',
    'students.all': 'All',
    'students.all_years': 'All Years',
    'students.select_gender': 'Select Gender',
    'students.optional': 'Optional',
    'students.save_student': 'Save Student',
    'students.edit_student': 'Edit Student',
    'students.enrollment_status': 'Enrollment Status',
    'students.per_page': 'Per Page',
    'students.filter': 'Filter',
    'students.clear': 'Clear',
    'students.id': 'ID',
    'students.login_code_header': 'Login Code',
    'students.full_name_header': 'Full Name',
    'students.gender_header': 'Gender',
    'students.year_header': 'Year',
    'students.grade_header': 'Grade',
    'students.class_header': 'Class',
    'students.status_header': 'Status',
    'students.actions': 'Actions',
    'students.auto_generated': 'Auto-generated',
    'students.login_code_help': '8-digit unique code for student login',
    'students.enrollment_info': 'Enrollment Information',
    'students.enroll_immediately': 'Enroll student immediately',
    'students.enroll_help': 'Check this to assign the student to a class right away',
    'students.active': 'Active',
    'students.disabled': 'Disabled',
    'students.inactive': 'Inactive',
    'students.graduated': 'Graduated',
    
    // Enrollments
    'enrollments.title': 'Enrollments Management',
    'enrollments.subtitle': 'Manage student enrollments and class assignments',
    'enrollments.transfer_selected': 'Transfer Selected',
    'enrollments.bulk_enroll': 'Bulk Enroll',
    'enrollments.add_enrollment': 'Add Enrollment',
    'enrollments.student_name': 'Student Name',
    'enrollments.search_placeholder': 'Search by student name...',
    'enrollments.academic_year': 'Academic Year',
    'enrollments.all_years': 'All Years',
    'enrollments.grade': 'Grade',
    'enrollments.all_grades': 'All Grades',
    'enrollments.class': 'Class',
    'enrollments.all_classes': 'All Classes',
    'enrollments.status': 'Status',
    'enrollments.all': 'All',
    'enrollments.active': 'Active',
    'enrollments.inactive': 'Inactive',
    'enrollments.graduated': 'Graduated',
    'enrollments.transferred': 'Transferred',
    'enrollments.per_page': 'Per Page',
    'enrollments.filter': 'Filter',
    'enrollments.clear': 'Clear',
    'enrollments.list_title': 'Enrollments List',
    'enrollments.loading': 'Loading enrollments...',
    
    // Table headers for Enrollments
    'table.enrollment_id': 'ID',
    'table.enrollment_student': 'Student',
    'table.enrollment_year': 'Year',
    'table.enrollment_grade': 'Grade',
    'table.enrollment_class': 'Class',
    'table.enrollment_status': 'Status',
    'table.enrollment_date': 'Enrolled Date',
    'table.enrollment_actions': 'Actions',
    
    // Exams
    'exams.title': 'Exams',
    'exams.subtitle': 'Manage exams and assessments',
    'exams.add_exam': 'Add Exam',
    'exams.add_exam_group': 'Add Exam Group',
    'exams.search': 'Search',
    'exams.search_placeholder': 'Search by title',
    'exams.year': 'Year',
    'exams.all_years': 'All Years',
    'exams.term': 'Term',
    'exams.all_terms': 'All Terms',
    'exams.grade': 'Grade',
    'exams.all_grades': 'All Grades',
    'exams.filter': 'Filter',
    'exams.clear': 'Clear',
    'exams.select_all': 'Select All',
    'exams.delete_selected': 'Delete Selected',
    'exams.export': 'Export',
    'exams.loading': 'Loading exams...',
    'exams.no_exams_found': 'No exams found',
    'exams.failed_to_load': 'Failed to load exams',
    
    // Table headers for Exams
    'table.exam_title': 'Title',
    'table.exam_year': 'Year',
    'table.exam_term': 'Term',
    'table.exam_grade': 'Grade',
    'table.exam_subject': 'Subject',
    'table.exam_date': 'Exam Date',
    'table.exam_score_range': 'Score Range',
    'table.exam_status': 'Status',
    'table.exam_actions': 'Actions',
    
    // Results - Results Management
    'results.title': 'Results Management',
    'results.subtitle': 'Manage exam results and student performance',
    'results.add_result': 'Add Result',
    'results.bulk_by_exam': 'Bulk by Exam',
    'results.student_results': 'Student Results',
    'results.import': 'Import',
    'results.export': 'Export',
    'results.delete_selected': 'Delete Selected',
    'results.filters_search': 'Filters & Search',
    'results.all_years': 'All Years',
    'results.all_terms': 'All Terms',
    'results.all_grades': 'All Grades',
    'results.all_subjects': 'All Subjects',
    'results.all_exams': 'All Exams',
    'results.search_students': 'Search students...',
    'results.apply_filters': 'Apply Filters',
    'results.clear_filters': 'Clear',
    'results.results_list': 'Results List',
    'results.select_all': 'Select All',
    'results.loading': 'Loading results...',
    'results.no_results_found': 'No results found',
    'results.error_loading': 'Error loading results',
    'results.failed_to_load': 'Failed to load results',
    'results.count': 'results found',
    'results.showing': 'Showing',
    'results.to': 'to',
    'results.of': 'of',
    'results.results': 'results',
    
    // Table headers for Results
    'table.result_student': 'Student',
    'table.result_exam': 'Exam',
    'table.result_score': 'Score',
    'table.result_percentage': 'Percentage',
    'table.result_pass_fail': 'Pass/Fail Status',
    'table.result_year_term': 'Year/Term',
    'table.result_subject': 'Subject',
    'table.result_date_added': 'Date Added',
    'table.result_actions': 'Actions',
    
    // Payments - Payment Management
    'payments.title': 'Payments',
    'payments.subtitle': 'Manage student payments and fee tracking',
    'payments.search_options': 'Search Options',
    'payments.search_help': 'Choose how you want to search for payments:',
    'payments.student_search_pay': 'Student Search & Pay',
    'payments.student_search_desc': 'Find specific students to view their payment timeline and record new payments',
    'payments.search_placeholder': 'Search by name, student ID, or national ID...',
    'payments.search_students': 'Search Students',
    'payments.payment_history_search': 'Payment History Search',
    'payments.payment_history_desc': 'Search all payments across students using filters (Year, Grade, Class, Date, Amount)',
    'payments.search_all_history': 'Search All Payment History',
    'payments.show_advanced_filters': 'Show Advanced Filters',
    'payments.hide_advanced_filters': 'Hide Advanced Filters',
    'payments.academic_year': 'Academic Year',
    'payments.all_years': 'All Years',
    'payments.grade': 'Grade',
    'payments.all_grades': 'All Grades',
    'payments.class': 'Class',
    'payments.all_classes': 'All Classes',
    'payments.payment_method': 'Payment Method',
    'payments.all_methods': 'All Methods',
    'payments.cash': 'Cash',
    'payments.card': 'Card',
    'payments.bank_transfer': 'Bank Transfer',
    'payments.digital_wallet': 'Digital Wallet',
    'payments.date_from': 'Date From',
    'payments.date_to': 'Date To',
    'payments.min_amount': 'Min Amount',
    'payments.max_amount': 'Max Amount',
    'payments.quick_date_filters': 'Quick Date Filters',
    'payments.show_only': 'Show Only',
    'payments.last_payments': 'Last Payments',
    'payments.recent_30_days': 'Recent (30 days)',
    'payments.old_90_days': 'Old (90+ days)',
    'payments.apply_filters': 'Apply Filters',
    'payments.clear_all': 'Clear All',
    'payments.search_results': 'Search Results',
    'payments.payment_history_results': 'Payment History Search Results',
    'payments.payments_found': 'payments found',
    'payments.record_payment': 'Record Payment',
    'payments.failed_to_load': 'Failed to load payments',
    'payments.failed_search': 'Failed to search payments',
    'payments.failed_record': 'Failed to record payment',
    'payments.failed_update': 'Failed to update payment',
    'payments.failed_delete': 'Failed to delete payment',
    
    // Table headers for Payments
    'table.payment_student': 'Student',
    'table.payment_amount': 'Amount',
    'table.payment_method': 'Method',
    'table.payment_date': 'Date',
    'table.payment_year': 'Year',
    'table.payment_grade': 'Grade',
    'table.payment_class': 'Class',
    'table.payment_notes': 'Notes',
    'table.payment_actions': 'Actions',
    
    // User Management
    'users.title': 'User Management',
    'users.subtitle': 'Manage admin users and their permissions',
    'users.add_user': 'Add User',
    'users.search': 'Search',
    'users.search_placeholder': 'Username or full name...',
    'users.role': 'Role',
    'users.all_roles': 'All Roles',
    'users.status': 'Status',
    'users.all_statuses': 'All Statuses',
    'users.enabled': 'Enabled',
    'users.disabled': 'Disabled',
    'users.sort_by': 'Sort By',
    'users.order': 'Order',
    'users.descending': 'Descending',
    'users.ascending': 'Ascending',
    'users.loading': 'Loading users...',
    'users.error_loading': 'Error loading users',
    'users.error_loading_data': 'Error loading users data',
    'users.username': 'Username',
    'users.full_name': 'Full Name',
    'users.last_login': 'Last Login',
    'users.created': 'Created',
    'users.never': 'Never',
    'users.admin': 'Admin',
    'users.registrar': 'Registrar',
    'users.teacher': 'Teacher',
    'users.accountant': 'Accountant',
    'users.edit_user': 'Edit User',
    'users.add_new_user': 'Add New User',
    'users.username_label': 'Username *',
    'users.username_placeholder': 'Enter username',
    'users.full_name_label': 'Full Name *',
    'users.full_name_placeholder': 'Enter full name',
    'users.password_label': 'Password',
    'users.password_placeholder': 'Enter password (leave blank to keep current)',
    'users.role_label': 'Role *',
    'users.select_role': 'Select role',
    'users.enabled_label': 'Enabled',
    'users.save_user': 'Save User',
    'users.user_created': 'User created successfully',
    'users.user_updated': 'User updated successfully',
    'users.confirm_delete': 'Are you sure you want to delete this user? This action cannot be undone.',
    'users.error_saving': 'Error saving user',
    'users.error_loading_user': 'Error loading user data',
    'users.error_updating_status': 'Error updating user status',
    'users.error_deleting': 'Error deleting user',
    
    // Table headers for Users
    'table.user_id': 'ID',
    'table.user_username': 'Username',
    'table.user_full_name': 'Full Name',
    'table.user_role': 'Role',
    'table.user_status': 'Status',
    'table.user_last_login': 'Last Login',
    'table.user_created': 'Created',
    'table.user_actions': 'Actions',
    
    // Settings
    'settings.title': 'System Settings',
    'settings.subtitle': 'Configure system preferences and policies',
    'settings.save_all': 'Save All Settings',
    'settings.school_settings': 'School Settings',
    'settings.school_name': 'School Name',
    'settings.school_name_placeholder': 'Enter school name',
    'settings.school_name_help': 'This will appear on student cards and portal',
    'settings.portal_url': 'Student Portal URL',
    'settings.portal_url_placeholder': 'http://localhost/student1/student/',
    'settings.portal_url_help': 'URL for QR codes on student cards',
    'settings.academic_visibility': 'Academic Visibility',
    'settings.current_academic_year': 'Current Academic Year',
    'settings.select_year': 'Select Year',
    'settings.first_term_visible': 'First Term Results Visible',
    'settings.first_term_publish_date': 'First Term Publish Date',
    'settings.second_term_visible': 'Second Term Results Visible',
    'settings.second_term_publish_date': 'Second Term Publish Date',
    'settings.display_options': 'Display Options',
    'settings.display_mode': 'Display Mode',
    'settings.color_only': 'Color Only',
    'settings.color_score': 'Color + Score',
    'settings.color_score_percent': 'Color + Score + Percent',
    'settings.percentage_rounding': 'Percentage Rounding (decimal places)',
    'settings.rounding_0': '0 (85%)',
    'settings.rounding_1': '1 (84.5%)',
    'settings.rounding_2': '2 (84.56%)',
    'settings.pass_rules': 'Pass Rules',
    'settings.per_subject_threshold': 'Per Subject Threshold Mode',
    'settings.use_grade_subject_min': 'Use Grade Subject Minimum',
    'settings.fixed_percentage': 'Fixed Percentage',
    'settings.subject_pass_min_percent': 'Subject Pass Min Percent',
    'settings.overall_pass_rule': 'Overall Pass Rule',
    'settings.none': 'None',
    'settings.avg_at_least': 'Average At Least',
    'settings.overall_pass_min_percent': 'Overall Pass Min Percent',
    'settings.pass_condition': 'Pass Condition',
    'settings.all_subjects_only': 'All Subjects Only',
    'settings.overall_only': 'Overall Only',
    'settings.all_subjects_or_overall': 'All Subjects OR Overall',
    'settings.all_subjects_and_overall': 'All Subjects AND Overall',
    'settings.security_policy': 'Security Policy',
    'settings.mask_national_id': 'Mask National ID in Admin Interface',
    'settings.unique_national_id': 'Student Login Requires Unique National ID',
    'settings.session_timeout': 'Session Timeout (minutes)',
    'settings.grade_costs': 'Grade Costs',
    'settings.add_grade_cost': 'Add Grade Cost',
    'settings.select_grade': 'Select Grade',
    'settings.amount_placeholder': 'Amount',
    'settings.no_grade_costs': 'No grade costs configured. Click "Add Grade Cost" to get started.',
    'settings.percentage_bands': 'Percentage Bands',
    'settings.add_percentage_band': 'Add Percentage Band',
    'settings.grade_visibility': 'Grade Result Visibility',
    'settings.add_grade_visibility': 'Add Grade Visibility Rule',
    'settings.grade_visibility_help': 'Control which grades can see results in the student portal. Students also need to pay grade costs to view results.',
    'settings.failed_to_load': 'Failed to load settings',
    'settings.failed_to_save': 'Failed to save settings',
    
    // Import
    'import.title': 'Import Students',
    'import.with_enrollment': 'Import Students with Enrollment',
    'import.instructions': 'Instructions',
    'import.required': 'Required',
    'import.optional': 'Optional',
    'import.download_template': 'Download Template CSV',
    'import.csv_format': 'CSV Format Example',
    'import.select_file': 'Select CSV File',
    'import.upload': 'Upload',
    'import.processing': 'Processing...',
    'import.results': 'Import Results',
    'import.total_rows': 'Total Rows',
    'import.successful': 'Successful',
    'import.failed': 'Failed',
    
    // Buttons and Actions
    'btn.save_all': 'Save All Settings',
    'btn.download_csv': 'Download CSV',
    'btn.print_cards': 'Print Cards',
    'btn.view_timeline': 'View Timeline',
    'btn.record_payment': 'Record Payment',
    'btn.delete_selected': 'Delete Selected',
    
    // Modals
    'modal.confirm_delete': 'Are you sure you want to delete this item?',
    'modal.confirm_logout': 'Are you sure you want to logout?',
    'modal.close': 'Close',
    
    // Messages
    'msg.saved_successfully': 'Saved successfully',
    'msg.deleted_successfully': 'Deleted successfully',
    'msg.error_occurred': 'An error occurred',
    'msg.no_data': 'No data available',
    'msg.loading_data': 'Loading data...',
    
    // Form Labels
    'form.select_year': 'Select Year',
    'form.select_grade': 'Select Grade',
    'form.select_class': 'Select Class',
    'form.select_subject': 'Select Subject',
    'form.select_term': 'Select Term',
    'form.amount': 'Amount',
    'form.date': 'Date',
    'form.notes': 'Notes',
    
    // Table Headers
    'table.id': 'ID',
    'table.name': 'Name',
    'table.code': 'Code',
    'table.title': 'Title',
    'table.created_at': 'Created',
    'table.updated_at': 'Updated',
    
    // Language
    'lang.english': 'English',
    'lang.arabic': 'العربية',
    'lang.switch_to': 'Switch to'
};