<?php
require_once __DIR__ . '/../src/Core/Database.php';

use App\Core\Database;

header('Content-Type: application/json');

try {
    $db = Database::getConnection();
    
    $loginCode = '45402832';
    $nationalId = '567890123458';
    
    echo "=== STUDENT LOGIN DEBUG ===\n\n";
    
    // Check if academic_visibility table has current year
    echo "1. Checking academic visibility:\n";
    $stmt = $db->prepare("SELECT * FROM academic_visibility LIMIT 1");
    $stmt->execute();
    $visibility = $stmt->fetch();
    
    if ($visibility) {
        echo "✓ Academic visibility found:\n";
        echo "  Current Year ID: " . ($visibility['current_year_id'] ?? 'NULL') . "\n";
        echo "  First Term Visible: " . ($visibility['first_term_visible'] ? 'Yes' : 'No') . "\n";
        echo "  Second Term Visible: " . ($visibility['second_term_visible'] ? 'Yes' : 'No') . "\n\n";
    } else {
        echo "✗ No academic visibility configuration found!\n\n";
    }
    
    // Check if academic years exist
    echo "2. Available academic years:\n";
    $stmt = $db->prepare("SELECT id, name, status FROM academic_years ORDER BY name DESC");
    $stmt->execute();
    $years = $stmt->fetchAll();
    
    if ($years) {
        foreach ($years as $year) {
            echo "  ID: {$year['id']}, Name: {$year['name']}, Status: {$year['status']}\n";
        }
        echo "\n";
    } else {
        echo "✗ No academic years found!\n\n";
    }
    
    // Check if student exists with this login code
    echo "3. Checking student with login code '$loginCode':\n";
    $stmt = $db->prepare("SELECT id, login_code, full_name, national_id, enabled FROM students WHERE login_code = ?");
    $stmt->execute([$loginCode]);
    $student = $stmt->fetch();
    
    if ($student) {
        echo "✓ Student found:\n";
        echo "  ID: {$student['id']}\n";
        echo "  Name: {$student['full_name']}\n";
        echo "  Login Code: {$student['login_code']}\n";
        echo "  National ID: {$student['national_id']}\n";
        echo "  Enabled: " . ($student['enabled'] ? 'Yes' : 'No') . "\n\n";
        
        // Check if national ID matches
        if ($student['national_id'] === $nationalId) {
            echo "✓ National ID matches!\n\n";
        } else {
            echo "✗ National ID doesn't match! Expected: '{$student['national_id']}', Got: '$nationalId'\n\n";
        }
        
        // Check enrollments for this student
        echo "4. Student enrollments:\n";
        $stmt = $db->prepare("
            SELECT e.id, e.year_id, e.grade_id, e.class_id, e.status,
                   ay.name as year_name, g.title as grade_title, c.name as class_name
            FROM enrollments e
            LEFT JOIN academic_years ay ON e.year_id = ay.id
            LEFT JOIN grades g ON e.grade_id = g.id
            LEFT JOIN classes c ON e.class_id = c.id
            WHERE e.student_id = ?
            ORDER BY e.created_at DESC
        ");
        $stmt->execute([$student['id']]);
        $enrollments = $stmt->fetchAll();
        
        if ($enrollments) {
            foreach ($enrollments as $enrollment) {
                echo "  Enrollment ID: {$enrollment['id']}\n";
                echo "    Year: {$enrollment['year_name']} (ID: {$enrollment['year_id']})\n";
                echo "    Grade: {$enrollment['grade_title']} (ID: {$enrollment['grade_id']})\n";
                echo "    Class: {$enrollment['class_name']} (ID: {$enrollment['class_id']})\n";
                echo "    Status: {$enrollment['status']}\n\n";
            }
        } else {
            echo "✗ No enrollments found for this student!\n\n";
        }
        
    } else {
        echo "✗ No student found with login code '$loginCode'\n\n";
        
        // Show some existing students
        echo "Available students with login codes:\n";
        $stmt = $db->prepare("SELECT id, login_code, full_name, national_id FROM students WHERE login_code IS NOT NULL LIMIT 10");
        $stmt->execute();
        $students = $stmt->fetchAll();
        
        if ($students) {
            foreach ($students as $s) {
                echo "  ID: {$s['id']}, Login: {$s['login_code']}, Name: {$s['full_name']}, National ID: {$s['national_id']}\n";
            }
        } else {
            echo "  No students with login codes found!\n";
        }
    }
    
    echo "\n5. Testing the exact authentication query:\n";
    $currentYearId = $visibility['current_year_id'] ?? null;
    
    if ($currentYearId) {
        $stmt = $db->prepare("
            SELECT s.id, s.login_code, s.full_name, s.national_id, 
                   e.year_id, e.grade_id, e.class_id,
                   g.title as grade_title, c.name as class_code,
                   ay.name as year_name
            FROM students s
            JOIN enrollments e ON s.id = e.student_id
            JOIN grades g ON e.grade_id = g.id
            JOIN classes c ON e.class_id = c.id
            JOIN academic_years ay ON e.year_id = ay.id
            WHERE s.login_code = ? 
            AND s.national_id = ? 
            AND s.enabled = 1
            AND e.year_id = ?
            AND e.status = 'active'
        ");
        
        $stmt->execute([$loginCode, $nationalId, $currentYearId]);
        $authResult = $stmt->fetch();
        
        if ($authResult) {
            echo "✓ Authentication would succeed!\n";
            echo "  Student: {$authResult['full_name']}\n";
            echo "  Year: {$authResult['year_name']}\n";
            echo "  Grade: {$authResult['grade_title']}\n";
            echo "  Class: {$authResult['class_code']}\n";
        } else {
            echo "✗ Authentication failed with current year ID: $currentYearId\n";
            echo "  Either student not found, not enabled, enrollment not active, or wrong year\n";
        }
    } else {
        echo "✗ Cannot test authentication - no current year configured!\n";
    }
    
} catch (Exception $e) {
    echo "Error: " . $e->getMessage() . "\n";
    echo "File: " . $e->getFile() . "\n";
    echo "Line: " . $e->getLine() . "\n";
}
?>