<?php
// Simple debug script to test API
error_reporting(E_ALL);
ini_set('display_errors', 1);

header('Content-Type: application/json');
header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Methods: GET, POST, PUT, DELETE, OPTIONS');
header('Access-Control-Allow-Headers: Content-Type, Authorization');

if ($_SERVER['REQUEST_METHOD'] === 'OPTIONS') {
    http_response_code(200);
    exit();
}

try {
    // Test database connection
    $pdo = new PDO('mysql:host=localhost;dbname=student1;charset=utf8mb4', 'root', 'mysql');
    
    if ($_SERVER['REQUEST_METHOD'] === 'POST') {
        $input = json_decode(file_get_contents('php://input'), true);
        
        if (!$input) {
            echo json_encode(['success' => false, 'message' => 'Invalid JSON']);
            exit();
        }
        
        $username = $input['username'] ?? '';
        $password = $input['password'] ?? '';
        
        if (!$username || !$password) {
            echo json_encode(['success' => false, 'message' => 'Username and password required']);
            exit();
        }
        
        $stmt = $pdo->prepare("SELECT id, username, password_hash, role, full_name FROM admin_users WHERE username = ? AND enabled = 1");
        $stmt->execute([$username]);
        $user = $stmt->fetch();
        
        if (!$user || !password_verify($password, $user['password_hash'])) {
            echo json_encode(['success' => false, 'message' => 'Invalid credentials']);
            exit();
        }
        
        // Simple JWT-like token (for testing)
        $payload = [
            'type' => 'admin',
            'user_id' => $user['id'],
            'username' => $user['username'],
            'role' => $user['role'],
            'full_name' => $user['full_name'],
            'exp' => time() + 28800 // 8 hours
        ];
        
        $token = base64_encode(json_encode($payload));
        
        echo json_encode([
            'success' => true,
            'message' => 'Login successful',
            'data' => [
                'token' => $token,
                'user' => [
                    'id' => $user['id'],
                    'username' => $user['username'],
                    'role' => $user['role'],
                    'full_name' => $user['full_name']
                ],
                'expires_in' => 28800
            ]
        ]);
        exit();
    }
    
    if ($_SERVER['REQUEST_METHOD'] === 'GET' && strpos($_SERVER['REQUEST_URI'], 'me') !== false) {
        $headers = getallheaders();
        $authHeader = $headers['Authorization'] ?? '';
        
        if (!$authHeader || !str_starts_with($authHeader, 'Bearer ')) {
            echo json_encode(['success' => false, 'message' => 'Authentication required']);
            exit();
        }
        
        $token = substr($authHeader, 7);
        $payload = json_decode(base64_decode($token), true);
        
        if (!$payload || !isset($payload['exp']) || $payload['exp'] < time()) {
            echo json_encode(['success' => false, 'message' => 'Invalid or expired token']);
            exit();
        }
        
        echo json_encode(['success' => true, 'data' => $payload]);
        exit();
    }
    
    if ($_SERVER['REQUEST_METHOD'] === 'GET' && strpos($_SERVER['REQUEST_URI'], 'academic-years') !== false) {
        // Sample academic years data
        $years = [
            [
                'id' => 1,
                'name' => '2024-2025',
                'starts_on' => '2024-09-01',
                'ends_on' => '2025-06-30',
                'status' => 'open',
                'created_at' => '2024-08-01 10:00:00'
            ],
            [
                'id' => 2,
                'name' => '2023-2024',
                'starts_on' => '2023-09-01',
                'ends_on' => '2024-06-30',
                'status' => 'closed',
                'created_at' => '2023-08-01 10:00:00'
            ]
        ];
        
        echo json_encode([
            'success' => true,
            'data' => $years,
            'meta' => [
                'page' => 1,
                'per_page' => 50,
                'total_rows' => count($years),
                'total_pages' => 1,
                'sort_by' => null,
                'sort_dir' => 'asc'
            ]
        ]);
        exit();
    }
    
    echo json_encode(['success' => true, 'message' => 'API is working', 'method' => $_SERVER['REQUEST_METHOD'], 'uri' => $_SERVER['REQUEST_URI']]);
    
} catch (Exception $e) {
    echo json_encode(['success' => false, 'message' => 'Error: ' . $e->getMessage()]);
}