<?php
require_once __DIR__ . '/../src/Core/Database.php';

use App\Core\Database;

header('Content-Type: application/json');

try {
    $db = Database::getConnection();
    
    echo "=== FIXING ACADEMIC YEAR CONFIGURATION ===\n\n";
    
    // Check current configuration
    $stmt = $db->prepare("SELECT * FROM academic_visibility LIMIT 1");
    $stmt->execute();
    $visibility = $stmt->fetch();
    
    echo "Current configuration:\n";
    echo "  Current Year ID: " . ($visibility['current_year_id'] ?? 'NULL') . "\n\n";
    
    // Update to use the newer academic year (2025-2026, ID: 6)
    if ($visibility) {
        $stmt = $db->prepare("UPDATE academic_visibility SET current_year_id = ? WHERE id = ?");
        $stmt->execute([6, $visibility['id']]);
        echo "✓ Updated current year ID from {$visibility['current_year_id']} to 6 (2025-2026)\n\n";
    } else {
        $stmt = $db->prepare("INSERT INTO academic_visibility (current_year_id, first_term_visible, second_term_visible) VALUES (?, 1, 1)");
        $stmt->execute([6]);
        echo "✓ Created new academic visibility configuration with year ID 6 (2025-2026)\n\n";
    }
    
    // Verify the fix
    $stmt = $db->prepare("SELECT * FROM academic_visibility LIMIT 1");
    $stmt->execute();
    $newVisibility = $stmt->fetch();
    
    echo "New configuration:\n";
    echo "  Current Year ID: " . $newVisibility['current_year_id'] . "\n";
    echo "  First Term Visible: " . ($newVisibility['first_term_visible'] ? 'Yes' : 'No') . "\n";
    echo "  Second Term Visible: " . ($newVisibility['second_term_visible'] ? 'Yes' : 'No') . "\n\n";
    
    // Test the login again
    echo "Testing login with new configuration:\n";
    $loginCode = '45402832';
    $nationalId = '567890123458';
    
    $stmt = $db->prepare("
        SELECT s.id, s.login_code, s.full_name, s.national_id, 
               e.year_id, e.grade_id, e.class_id,
               g.title as grade_title, c.name as class_code,
               ay.name as year_name
        FROM students s
        JOIN enrollments e ON s.id = e.student_id
        JOIN grades g ON e.grade_id = g.id
        JOIN classes c ON e.class_id = c.id
        JOIN academic_years ay ON e.year_id = ay.id
        WHERE s.login_code = ? 
        AND s.national_id = ? 
        AND s.enabled = 1
        AND e.year_id = ?
        AND e.status = 'active'
    ");
    
    $stmt->execute([$loginCode, $nationalId, $newVisibility['current_year_id']]);
    $authResult = $stmt->fetch();
    
    if ($authResult) {
        echo "✓ Authentication will now succeed!\n";
        echo "  Student: {$authResult['full_name']}\n";
        echo "  Year: {$authResult['year_name']}\n";
        echo "  Grade: {$authResult['grade_title']}\n";
        echo "  Class: {$authResult['class_code']}\n";
        echo "\nYou can now login with:\n";
        echo "  Login Code: $loginCode\n";
        echo "  National ID: $nationalId\n";
    } else {
        echo "✗ Authentication still failed. There might be another issue.\n";
    }
    
} catch (Exception $e) {
    echo "Error: " . $e->getMessage() . "\n";
}
?>