<?php

use App\Controllers\AuthController;
use App\Controllers\AcademicYearController;
use App\Controllers\StudentController;
use App\Controllers\ExamController;
use App\Controllers\ResultController;
use App\Controllers\PaymentController;
use App\Controllers\SettingsController;
use App\Controllers\SchoolController;
use App\Middleware\AuthMiddleware;
use App\Middleware\AdminAuthMiddleware;
use App\Middleware\StudentAuthMiddleware;
use App\Middleware\PermissionMiddleware;

// Authentication routes
$router->post('/auth/admin/login', 'App\Controllers\AuthController@adminLogin');
$router->post('/auth/student/login', 'App\Controllers\AuthController@studentLogin');
$router->get('/auth/me', 'App\Controllers\AuthController@me', [AuthMiddleware::class]);
$router->post('/auth/refresh', 'App\Controllers\AuthController@refresh', [AuthMiddleware::class]);

// Test route using existing controller
$router->get('/admin/payments/search-test', 'App\Controllers\StudentController@index', [
    AdminAuthMiddleware::class
]);

// Admin-only routes
$router->get('/admin/academic-years', 'App\Controllers\AcademicYearController@index', [
    AdminAuthMiddleware::class, new PermissionMiddleware('academic_years', 'read')
]);
$router->post('/admin/academic-years', 'App\Controllers\AcademicYearController@store', [
    AdminAuthMiddleware::class, new PermissionMiddleware('academic_years', 'create')
]);
$router->get('/admin/academic-years/{id}', 'App\Controllers\AcademicYearController@show', [
    AdminAuthMiddleware::class, new PermissionMiddleware('academic_years', 'read')
]);
$router->put('/admin/academic-years/{id}', 'App\Controllers\AcademicYearController@update', [
    AdminAuthMiddleware::class, new PermissionMiddleware('academic_years', 'update')
]);
$router->delete('/admin/academic-years/{id}', 'App\Controllers\AcademicYearController@destroy', [
    AdminAuthMiddleware::class, new PermissionMiddleware('academic_years', 'delete')
]);

// Terms
$router->get('/admin/terms', 'App\Controllers\TermController@index', [
    AdminAuthMiddleware::class, new PermissionMiddleware('terms', 'read')
]);
$router->post('/admin/terms', 'App\Controllers\TermController@store', [
    AdminAuthMiddleware::class, new PermissionMiddleware('terms', 'create')
]);
$router->put('/admin/terms/{id}', 'App\Controllers\TermController@update', [
    AdminAuthMiddleware::class, new PermissionMiddleware('terms', 'update')
]);
$router->delete('/admin/terms/{id}', 'App\Controllers\TermController@destroy', [
    AdminAuthMiddleware::class, new PermissionMiddleware('terms', 'delete')
]);

// Grades
$router->get('/admin/grades', 'App\Controllers\GradeController@index', [
    AdminAuthMiddleware::class, new PermissionMiddleware('grades', 'read')
]);
$router->post('/admin/grades', 'App\Controllers\GradeController@store', [
    AdminAuthMiddleware::class, new PermissionMiddleware('grades', 'create')
]);
$router->put('/admin/grades/{id}', 'App\Controllers\GradeController@update', [
    AdminAuthMiddleware::class, new PermissionMiddleware('grades', 'update')
]);
$router->delete('/admin/grades/{id}', 'App\Controllers\GradeController@destroy', [
    AdminAuthMiddleware::class, new PermissionMiddleware('grades', 'delete')
]);

// Classes
$router->get('/admin/classes', 'App\Controllers\ClassController@index', [
    AdminAuthMiddleware::class, new PermissionMiddleware('classes', 'read')
]);
$router->post('/admin/classes', 'App\Controllers\ClassController@store', [
    AdminAuthMiddleware::class, new PermissionMiddleware('classes', 'create')
]);
$router->put('/admin/classes/{id}', 'App\Controllers\ClassController@update', [
    AdminAuthMiddleware::class, new PermissionMiddleware('classes', 'update')
]);
$router->delete('/admin/classes/{id}', 'App\Controllers\ClassController@destroy', [
    AdminAuthMiddleware::class, new PermissionMiddleware('classes', 'delete')
]);

// Subjects
$router->get('/admin/subjects', 'App\Controllers\SubjectController@index', [
    AdminAuthMiddleware::class, new PermissionMiddleware('subjects', 'read')
]);
$router->post('/admin/subjects', 'App\Controllers\SubjectController@store', [
    AdminAuthMiddleware::class, new PermissionMiddleware('subjects', 'create')
]);
$router->put('/admin/subjects/{id}', 'App\Controllers\SubjectController@update', [
    AdminAuthMiddleware::class, new PermissionMiddleware('subjects', 'update')
]);
$router->delete('/admin/subjects/{id}', 'App\Controllers\SubjectController@destroy', [
    AdminAuthMiddleware::class, new PermissionMiddleware('subjects', 'delete')
]);

// Students
$router->get('/admin/students', 'App\Controllers\StudentController@index', [
    AdminAuthMiddleware::class, new PermissionMiddleware('students', 'read')
]);
$router->post('/admin/students', 'App\Controllers\StudentController@store', [
    AdminAuthMiddleware::class, new PermissionMiddleware('students', 'create')
]);
$router->get('/admin/students/{id}', 'App\Controllers\StudentController@show', [
    AdminAuthMiddleware::class, new PermissionMiddleware('students', 'read')
]);
$router->put('/admin/students/{id}', 'App\Controllers\StudentController@update', [
    AdminAuthMiddleware::class, new PermissionMiddleware('students', 'update')
]);
$router->delete('/admin/students/{id}', 'App\Controllers\StudentController@destroy', [
    AdminAuthMiddleware::class, new PermissionMiddleware('students', 'delete')
]);

// Enrollments
$router->get('/admin/enrollments', 'App\Controllers\EnrollmentController@index', [
    AdminAuthMiddleware::class, new PermissionMiddleware('enrollments', 'read')
]);
$router->post('/admin/enrollments', 'App\Controllers\EnrollmentController@store', [
    AdminAuthMiddleware::class, new PermissionMiddleware('enrollments', 'create')
]);
$router->put('/admin/enrollments/{id}', 'App\Controllers\EnrollmentController@update', [
    AdminAuthMiddleware::class, new PermissionMiddleware('enrollments', 'update')
]);

// Exams
$router->get('/admin/exams', 'App\Controllers\ExamController@index', [
    AdminAuthMiddleware::class, new PermissionMiddleware('exams', 'read')
]);
$router->post('/admin/exams', 'App\Controllers\ExamController@store', [
    AdminAuthMiddleware::class, new PermissionMiddleware('exams', 'create')
]);
$router->get('/admin/exams/{id}', 'App\Controllers\ExamController@show', [
    AdminAuthMiddleware::class, new PermissionMiddleware('exams', 'read')
]);
$router->put('/admin/exams/{id}', 'App\Controllers\ExamController@update', [
    AdminAuthMiddleware::class, new PermissionMiddleware('exams', 'update')
]);
$router->delete('/admin/exams/{id}', 'App\Controllers\ExamController@destroy', [
    AdminAuthMiddleware::class, new PermissionMiddleware('exams', 'delete')
]);

// Exam bulk operations
$router->delete('/admin/exams/bulk', 'App\Controllers\ExamController@bulkDelete', [
    AdminAuthMiddleware::class, new PermissionMiddleware('exams', 'delete')
]);
$router->post('/admin/exams/bulk-create', 'App\Controllers\ExamController@bulkCreate', [
    AdminAuthMiddleware::class, new PermissionMiddleware('exams', 'create')
]);
$router->get('/admin/exams/grade-subjects/{gradeId}', 'App\Controllers\ExamController@getGradeSubjects', [
    AdminAuthMiddleware::class, new PermissionMiddleware('exams', 'read')
]);

// Results
$router->get('/admin/results', 'App\Controllers\ResultController@index', [
    AdminAuthMiddleware::class, new PermissionMiddleware('exam_results', 'read')
]);
$router->post('/admin/results', 'App\Controllers\ResultController@store', [
    AdminAuthMiddleware::class, new PermissionMiddleware('exam_results', 'create')
]);
$router->get('/admin/results/{id}', 'App\Controllers\ResultController@show', [
    AdminAuthMiddleware::class, new PermissionMiddleware('exam_results', 'read')
]);
$router->put('/admin/results/{id}', 'App\Controllers\ResultController@update', [
    AdminAuthMiddleware::class, new PermissionMiddleware('exam_results', 'update')
]);
$router->delete('/admin/results/{id}', 'App\Controllers\ResultController@destroy', [
    AdminAuthMiddleware::class, new PermissionMiddleware('exam_results', 'delete')
]);
$router->delete('/admin/results/bulk', 'App\Controllers\ResultController@bulkDelete', [
    AdminAuthMiddleware::class, new PermissionMiddleware('exam_results', 'delete')
]);
$router->post('/admin/results/import', 'App\Controllers\ResultController@import', [
    AdminAuthMiddleware::class, new PermissionMiddleware('exam_results', 'create')
]);
$router->post('/admin/results/bulk', 'App\Controllers\ResultController@bulkStore', [
    AdminAuthMiddleware::class, new PermissionMiddleware('exam_results', 'create')
]);
$router->get('/admin/results/exam/{examId}', 'App\Controllers\ResultController@getByExam', [
    AdminAuthMiddleware::class, new PermissionMiddleware('exam_results', 'read')
]);
$router->get('/admin/results/template/{examId}', 'App\Controllers\ResultController@downloadTemplate', [
    AdminAuthMiddleware::class, new PermissionMiddleware('exam_results', 'read')
]);
$router->get('/admin/results/template-debug/{examId}', 'App\Controllers\ResultController@debugTemplate', [
    AdminAuthMiddleware::class, new PermissionMiddleware('exam_results', 'read')
]);

// Payments
$router->get('/admin/payments/search', 'App\Controllers\PaymentController@searchStudents', [
    AdminAuthMiddleware::class
]);
$router->get('/admin/students/{studentId}/timeline', 'App\Controllers\PaymentController@studentTimeline', [
    AdminAuthMiddleware::class, new PermissionMiddleware('payments', 'read')
]);
$router->get('/admin/enrollments/{enrollmentId}/payments', 'App\Controllers\PaymentController@index', [
    AdminAuthMiddleware::class, new PermissionMiddleware('payments', 'read')
]);
$router->post('/admin/enrollments/{enrollmentId}/payments', 'App\Controllers\PaymentController@store', [
    AdminAuthMiddleware::class, new PermissionMiddleware('payments', 'create')
]);
$router->put('/admin/payments/{id}', 'App\Controllers\PaymentController@update', [
    AdminAuthMiddleware::class, new PermissionMiddleware('payments', 'update')
]);
$router->delete('/admin/payments/{id}', 'App\Controllers\PaymentController@destroy', [
    AdminAuthMiddleware::class, new PermissionMiddleware('payments', 'delete')
]);

// Settings
$router->get('/admin/settings', 'App\Controllers\SettingsController@index', [
    AdminAuthMiddleware::class
]);
$router->put('/admin/settings', 'App\Controllers\SettingsController@update', [
    AdminAuthMiddleware::class
]);

// Student Portal routes
$router->get('/student/profile', 'App\Controllers\StudentPortalController@profile', [
    StudentAuthMiddleware::class
]);
$router->get('/student/results', 'App\Controllers\StudentPortalController@results', [
    StudentAuthMiddleware::class
]);

// School settings route
$router->get('/school/settings', 'App\Controllers\SchoolController@settings');

// Public routes (for data references)
$router->get('/public/grades', 'App\Controllers\PublicController@grades');
$router->get('/public/subjects', 'App\Controllers\PublicController@subjects');
$router->get('/public/classes', 'App\Controllers\PublicController@classes');
$router->get('/public/academic-years', 'App\Controllers\PublicController@academicYears');