<?php
// Simple debug script for student portal
error_reporting(E_ALL);
ini_set('display_errors', 1);

header('Content-Type: application/json');
header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Methods: GET, POST, PUT, DELETE, OPTIONS');
header('Access-Control-Allow-Headers: Content-Type, Authorization');

if ($_SERVER['REQUEST_METHOD'] === 'OPTIONS') {
    http_response_code(200);
    exit();
}

try {
    // Test database connection
    $pdo = new PDO('mysql:host=localhost;dbname=student1;charset=utf8mb4', 'root', 'mysql');
    
    if ($_SERVER['REQUEST_METHOD'] === 'POST') {
        $input = json_decode(file_get_contents('php://input'), true);
        
        if (!$input) {
            echo json_encode(['success' => false, 'message' => 'Invalid JSON']);
            exit();
        }
        
        $loginCode = $input['login_code'] ?? '';
        $nationalId = $input['national_id'] ?? '';
        
        if (!$loginCode || !$nationalId) {
            echo json_encode(['success' => false, 'message' => 'Both Unique ID and National ID are required.']);
            exit();
        }
        
        // Create a test student if none exists
        $stmt = $pdo->prepare("SELECT COUNT(*) FROM students");
        $stmt->execute();
        $studentCount = $stmt->fetchColumn();
        
        if ($studentCount == 0) {
            // Create test data
            $pdo->exec("INSERT INTO academic_years (name, status) VALUES ('2024-2025', 'open')");
            $yearId = $pdo->lastInsertId();
            
            $pdo->exec("INSERT INTO grades (code, title, sort_order) VALUES ('G10', 'Grade 10', 10)");
            $gradeId = $pdo->lastInsertId();
            
            $pdo->exec("INSERT INTO classes (year_id, grade_id, code) VALUES ($yearId, $gradeId, 'A')");
            $classId = $pdo->lastInsertId();
            
            $pdo->exec("INSERT INTO students (login_code, full_name, national_id) VALUES ('12345678', 'John Doe', 'ABC123')");
            $studentId = $pdo->lastInsertId();
            
            $pdo->exec("INSERT INTO enrollments (student_id, year_id, grade_id, class_id, status) VALUES ($studentId, $yearId, $gradeId, $classId, 'active')");
            
            $pdo->exec("INSERT INTO academic_visibility (current_year_id, first_term_visible, second_term_visible) VALUES ($yearId, 1, 1)");
        }
        
        // Find student
        $stmt = $pdo->prepare(
            "SELECT s.id, s.login_code, s.full_name, s.national_id, 
                    e.year_id, e.grade_id, e.class_id,
                    g.title as grade_title, c.code as class_code,
                    ay.name as year_name
             FROM students s
             JOIN enrollments e ON s.id = e.student_id
             JOIN grades g ON e.grade_id = g.id
             JOIN classes c ON e.class_id = c.id
             JOIN academic_years ay ON e.year_id = ay.id
             WHERE s.login_code = ? AND s.national_id = ? AND s.enabled = 1 AND e.status = 'active'"
        );
        
        $stmt->execute([$loginCode, $nationalId]);
        $student = $stmt->fetch();
        
        if (!$student) {
            echo json_encode(['success' => false, 'message' => 'We couldn\'t find a student matching those credentials.']);
            exit();
        }
        
        // Simple JWT-like token
        $payload = [
            'type' => 'student',
            'user_id' => $student['id'],
            'full_name' => $student['full_name'],
            'year_id' => $student['year_id'],
            'grade_id' => $student['grade_id'],
            'class_id' => $student['class_id'],
            'exp' => time() + 14400 // 4 hours
        ];
        
        $token = base64_encode(json_encode($payload));
        
        echo json_encode([
            'success' => true,
            'message' => 'Login successful',
            'data' => [
                'token' => $token,
                'student' => $student,
                'expires_in' => 14400
            ]
        ]);
        exit();
    }
    
    if ($_SERVER['REQUEST_METHOD'] === 'GET' && strpos($_SERVER['REQUEST_URI'], 'profile') !== false) {
        $headers = getallheaders();
        $authHeader = $headers['Authorization'] ?? '';
        
        if (!$authHeader || !str_starts_with($authHeader, 'Bearer ')) {
            echo json_encode(['success' => false, 'message' => 'Authentication required']);
            exit();
        }
        
        $token = substr($authHeader, 7);
        $payload = json_decode(base64_decode($token), true);
        
        if (!$payload || $payload['type'] !== 'student') {
            echo json_encode(['success' => false, 'message' => 'Invalid token']);
            exit();
        }
        
        $stmt = $pdo->prepare(
            "SELECT s.id, s.full_name, s.national_id, s.gender, s.birthdate,
                    ay.name as year_name, g.title as grade_title, c.code as class_code,
                    e.status as enrollment_status
             FROM students s
             JOIN enrollments e ON s.id = e.student_id
             JOIN academic_years ay ON e.year_id = ay.id
             JOIN grades g ON e.grade_id = g.id
             JOIN classes c ON e.class_id = c.id
             WHERE s.id = ? AND e.year_id = ?"
        );
        
        $stmt->execute([$payload['user_id'], $payload['year_id']]);
        $profile = $stmt->fetch();
        
        echo json_encode(['success' => true, 'data' => $profile]);
        exit();
    }
    
    if ($_SERVER['REQUEST_METHOD'] === 'GET' && strpos($_SERVER['REQUEST_URI'], 'results') !== false) {
        echo json_encode([
            'success' => true,
            'data' => [
                'results' => [],
                'display_options' => ['display_mode' => 'color_only', 'percent_rounding' => 0],
                'bands' => []
            ]
        ]);
        exit();
    }
    
    echo json_encode(['success' => true, 'message' => 'Student API is working']);
    
} catch (Exception $e) {
    echo json_encode(['success' => false, 'message' => 'Error: ' . $e->getMessage()]);
}