<?php
error_reporting(E_ALL);
ini_set('display_errors', 1);

echo "PHP Version: " . PHP_VERSION . "\n";
echo "Working directory: " . getcwd() . "\n";

// Test autoloader
spl_autoload_register(function ($class) {
    $prefix = 'App\\';
    $base_dir = __DIR__ . '/../src/';
    
    $len = strlen($prefix);
    if (strncmp($prefix, $class, $len) !== 0) {
        return;
    }
    
    $relative_class = substr($class, $len);
    $file = $base_dir . str_replace('\\', '/', $relative_class) . '.php';
    
    echo "Looking for class: $class\n";
    echo "File path: $file\n";
    echo "File exists: " . (file_exists($file) ? 'YES' : 'NO') . "\n";
    
    if (file_exists($file)) {
        require $file;
        echo "Loaded: $class\n";
    }
});

try {
    echo "Testing Router...\n";
    require_once __DIR__ . '/../src/Core/Router.php';
    $router = new App\Core\Router();
    echo "Router: OK\n";
    
    echo "Testing Request...\n";
    require_once __DIR__ . '/../src/Core/Request.php';
    $request = new App\Core\Request();
    echo "Request: OK\n";
    
    echo "Testing Response...\n";
    require_once __DIR__ . '/../src/Core/Response.php';
    $response = new App\Core\Response();
    echo "Response: OK\n";
    
    echo "Testing AuthController...\n";
    $authController = new App\Controllers\AuthController($request);
    echo "AuthController: OK\n";
    
} catch (Exception $e) {
    echo "Error: " . $e->getMessage() . "\n";
    echo "File: " . $e->getFile() . "\n";
    echo "Line: " . $e->getLine() . "\n";
}