<?php

namespace App\Controllers;

use App\Core\Controller;
use App\Core\Database;
use App\Core\Response;
use PDO;

class PercentageBandController extends Controller
{
    private PDO $db;
    
    public function __construct($request)
    {
        parent::__construct($request);
        $this->db = Database::getConnection();
    }
    
    public function index(): Response
    {
        try {
            $stmt = $this->db->prepare("
                SELECT id, label, start_percent, end_percent, color_hex, enabled
                FROM percentage_bands 
                ORDER BY start_percent ASC
            ");
            $stmt->execute();
            $bands = $stmt->fetchAll();
            
            return $this->response->success($bands);
            
        } catch (\Exception $e) {
            return $this->response->error('Failed to load percentage bands: ' . $e->getMessage(), 500);
        }
    }
}