<?php

namespace App\Controllers;

use App\Core\Controller;
use App\Core\Database;
use App\Core\Response;
use PDO;

class PublicController extends Controller
{
    private PDO $db;
    
    public function __construct($request)
    {
        parent::__construct($request);
        $this->db = Database::getConnection();
    }
    
    public function grades(): Response
    {
        try {
            $stmt = $this->db->prepare("SELECT id, title FROM grades ORDER BY title");
            $stmt->execute();
            $grades = $stmt->fetchAll();
            
            return $this->response->success($grades);
            
        } catch (\Exception $e) {
            return $this->response->error('Failed to load grades: ' . $e->getMessage(), 500);
        }
    }
    
    public function subjects(): Response
    {
        try {
            $stmt = $this->db->prepare("SELECT id, name FROM subjects ORDER BY name");
            $stmt->execute();
            $subjects = $stmt->fetchAll();
            
            return $this->response->success($subjects);
            
        } catch (\Exception $e) {
            return $this->response->error('Failed to load subjects: ' . $e->getMessage(), 500);
        }
    }
    
    public function classes(): Response
    {
        try {
            $stmt = $this->db->prepare("SELECT id, name FROM classes ORDER BY name");
            $stmt->execute();
            $classes = $stmt->fetchAll();
            
            return $this->response->success($classes);
            
        } catch (\Exception $e) {
            return $this->response->error('Failed to load classes: ' . $e->getMessage(), 500);
        }
    }
    
    public function academicYears(): Response
    {
        try {
            $stmt = $this->db->prepare("SELECT id, name FROM academic_years ORDER BY name DESC");
            $stmt->execute();
            $years = $stmt->fetchAll();
            
            return $this->response->success($years);
            
        } catch (\Exception $e) {
            return $this->response->error('Failed to load academic years: ' . $e->getMessage(), 500);
        }
    }
}