<?php

namespace App\Controllers;

use App\Core\Controller;
use App\Core\Database;
use App\Core\Response;
use PDO;

class SchoolController extends Controller
{
    private PDO $db;
    
    public function __construct($request)
    {
        parent::__construct($request);
        $this->db = Database::getConnection();
    }
    
    public function settings(): Response
    {
        try {
            $stmt = $this->db->prepare("SELECT * FROM school_settings LIMIT 1");
            $stmt->execute();
            $settings = $stmt->fetch();
            
            if (!$settings) {
                // Return default settings if none exist
                $settings = [
                    'school_name' => 'School Management System',
                    'student_portal_url' => 'http://localhost/student1/student/'
                ];
            }
            
            return $this->response->success($settings);
            
        } catch (\Exception $e) {
            return $this->response->error('Failed to load school settings: ' . $e->getMessage(), 500);
        }
    }
}