<?php

namespace App\Core;

use PDO;
use PDOException;

class Database
{
    private static ?PDO $connection = null;
    
    public static function getConnection(): PDO
    {
        if (self::$connection === null) {
            $config = require __DIR__ . '/../../config/config.php';
            $db = $config['database'];
            
            $dsn = "mysql:host={$db['host']};dbname={$db['database']};charset={$db['charset']}";
            
            try {
                self::$connection = new PDO($dsn, $db['username'], $db['password'], [
                    PDO::ATTR_ERRMODE => PDO::ERRMODE_EXCEPTION,
                    PDO::ATTR_DEFAULT_FETCH_MODE => PDO::FETCH_ASSOC,
                    PDO::ATTR_EMULATE_PREPARES => false
                ]);
            } catch (PDOException $e) {
                throw new \Exception("Database connection failed: " . $e->getMessage());
            }
        }
        
        return self::$connection;
    }
    
    public static function beginTransaction(): void
    {
        self::getConnection()->beginTransaction();
    }
    
    public static function commit(): void
    {
        self::getConnection()->commit();
    }
    
    public static function rollback(): void
    {
        self::getConnection()->rollback();
    }
}