// English Language Pack for Student Portal
const translations_en = {
    // Login
    'login.title': 'Student Portal',
    'login.welcome': 'Welcome back! Enter your credentials to access your academic dashboard',
    'login.code_label': '8-Digit Login Code',
    'login.national_id_label': 'National ID',
    'login.national_id_placeholder': 'Enter your national ID',
    'login.access_portal': 'Access Portal',
    'login.info': 'Both Login Code and National ID are required for secure access',
    'login.error': 'Login failed. Please check your credentials.',

    // Navigation
    'nav.student_portal': 'Student Portal',
    'nav.logout': 'Logout',

    // Welcome
    'welcome.title': 'Welcome back, {name}!',
    'welcome.subtitle': 'Ready to check your academic progress? Let\'s explore your results and achievements.',

    // Tabs
    'tab.profile': 'My Profile',
    'tab.results': 'My Results',
    'tab.statistics': 'Statistics',

    // Profile
    'profile.loading': 'Loading your profile...',
    'profile.personal_info': 'Personal Information',
    'profile.academic_info': 'Academic Information',
    'profile.full_name': 'Full Name',
    'profile.national_id': 'National ID',
    'profile.gender': 'Gender',
    'profile.birthdate': 'Birth Date',
    'profile.login_code': 'Login Code',
    'profile.grade': 'Grade',
    'profile.class': 'Class',
    'profile.academic_year': 'Academic Year',
    'profile.enrollment_status': 'Enrollment Status',
    'profile.status_active': 'Active',
    'profile.male': 'Male',
    'profile.female': 'Female',

    // Results
    'results.loading': 'Loading your results...',
    'results.title': 'Academic Results',
    'results.subtitle': 'Comprehensive review of your academic performance',
    'results.term': 'Term',
    'results.first_term': 'First Term',
    'results.second_term': 'Second Term',
    'results.final_term': 'Final Term',
    'results.no_results': 'No Results Available',
    'results.no_results_subtitle': 'Results for this term have not been published yet. Please check back later.',
    'results.subject': 'Subject',
    'results.score': 'Score',
    'results.max_score': 'Max Score',
    'results.percentage': 'Percentage',
    'results.grade': 'Grade',
    'results.total_score': 'Total Score',
    'results.exam_score': 'Exam Score',
    'results.activities_score': 'Activities Score',
    'results.progress': 'Progress',

    // Statistics
    'stats.loading': 'Calculating your statistics...',
    'stats.overall_average': 'Overall Average',
    'stats.across_subjects': 'Across all subjects',
    'stats.best_subject': 'Best Subject',
    'stats.score_label': 'Score:',
    'stats.improvement': 'Improvement',
    'stats.from_previous': 'From previous term',
    'stats.grade_level': 'Grade Level',
    'stats.current_standing': 'Current standing',
    'stats.achievements': 'Your Achievements',

    // Grade Labels
    'grade.excellent': 'Excellent',
    'grade.very_good': 'Very Good',
    'grade.good': 'Good',
    'grade.acceptable': 'Acceptable',
    'grade.weak': 'Weak',
    'grade.failed': 'Failed',

    // Achievement Badges
    'achievement.honor_roll': 'Honor Roll',
    'achievement.perfect_attendance': 'Perfect Attendance',
    'achievement.top_performer': 'Top Performer',
    'achievement.most_improved': 'Most Improved',
    'achievement.subject_champion': 'Subject Champion',

    // Common
    'common.loading': 'Loading...',
    'common.error': 'Error',
    'common.no_data': 'No data available',
    'common.total': 'Total',
    'common.average': 'Average',
    'common.percentage': 'Percentage',
    'common.score': 'Score',
    'common.out_of': 'out of',

    // Term Summary
    'summary.passed_subjects': 'Passed Subjects',
    'summary.failed_subjects': 'Failed Subjects',
    'summary.total_subjects': 'Total Subjects',
    'summary.overall_percentage': 'Overall Percentage',
    'summary.overall_progress': 'Overall Progress',

    // Language
    'lang.english': 'English',
    'lang.arabic': 'العربية',
    'lang.switch_to': 'Switch to'
};