// Language verification script for Node.js
const fs = require('fs');
const path = require('path');

// Read the language files
const arPath = path.join(__dirname, 'js/lang/ar.js');
const enPath = path.join(__dirname, 'js/lang/en.js');

function readLanguageFile(filePath) {
    const content = fs.readFileSync(filePath, 'utf8');
    // Extract the translations object using regex
    const match = content.match(/const translations_\w+ = ({[\s\S]*});/);
    if (match) {
        return eval('(' + match[1] + ')');
    }
    return null;
}

console.log('🔍 Verifying Arabic language support for Student Portal...\n');

try {
    const arTranslations = readLanguageFile(arPath);
    const enTranslations = readLanguageFile(enPath);
    
    if (!arTranslations) {
        console.log('❌ Failed to read Arabic translations');
        process.exit(1);
    }
    
    if (!enTranslations) {
        console.log('❌ Failed to read English translations');
        process.exit(1);
    }
    
    console.log('✅ Language files loaded successfully');
    console.log(`📊 Arabic translations: ${Object.keys(arTranslations).length} keys`);
    console.log(`📊 English translations: ${Object.keys(enTranslations).length} keys`);
    
    // Check if all English keys have Arabic translations
    const missingKeys = [];
    for (const key in enTranslations) {
        if (!arTranslations[key]) {
            missingKeys.push(key);
        }
    }
    
    if (missingKeys.length > 0) {
        console.log(`⚠️  Missing Arabic translations for ${missingKeys.length} keys:`);
        missingKeys.forEach(key => console.log(`   - ${key}`));
    } else {
        console.log('✅ All keys have Arabic translations');
    }
    
    // Test specific translations
    console.log('\n🧪 Testing specific translations:');
    console.log(`Login Title (EN): ${enTranslations['login.title']}`);
    console.log(`Login Title (AR): ${arTranslations['login.title']}`);
    console.log(`Profile Tab (EN): ${enTranslations['tab.profile']}`);
    console.log(`Profile Tab (AR): ${arTranslations['tab.profile']}`);
    console.log(`Results Tab (EN): ${enTranslations['tab.results']}`);
    console.log(`Results Tab (AR): ${arTranslations['tab.results']}`);
    
    // Check for RTL characters in Arabic translations
    const arabicPattern = /[\u0600-\u06FF\u0750-\u077F\u08A0-\u08FF\uFB50-\uFDFF\uFE70-\uFEFF]/;
    let hasArabicText = false;
    
    for (const key in arTranslations) {
        if (arabicPattern.test(arTranslations[key])) {
            hasArabicText = true;
            break;
        }
    }
    
    if (hasArabicText) {
        console.log('✅ Arabic text detected in translations');
    } else {
        console.log('⚠️  No Arabic text detected in translations');
    }
    
    console.log('\n🎉 Arabic language support verification completed!');
    console.log('\n📝 Next steps:');
    console.log('1. Visit: http://localhost/student1/student/test-lang.html');
    console.log('2. Click the English/العربية buttons to test language switching');
    console.log('3. Verify RTL layout and Arabic text display');
    console.log('4. Test the main portal at: http://localhost/student1/student/');
    
} catch (error) {
    console.error('❌ Error during verification:', error.message);
    process.exit(1);
}